/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.google.common.util.concurrent.RateLimiter;
import com.refinedmods.refinedstorage.api.autocrafting.calculation.CancellationToken;
import com.refinedmods.refinedstorage.api.autocrafting.preview.Preview;
import com.refinedmods.refinedstorage.api.autocrafting.preview.PreviewProvider;
import com.refinedmods.refinedstorage.api.autocrafting.preview.TreePreview;
import com.refinedmods.refinedstorage.api.autocrafting.task.TaskId;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.autocrafting.AutocraftingNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.SimpleNetworkNode;
import com.refinedmods.refinedstorage.api.network.storage.StorageNetworkComponent;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.storagemonitor.AutocraftingStorageMonitorExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorContainerMenu;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorInsertTracker;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.FilterWithFuzzyMode;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageMonitorBlockEntity
extends AbstractBaseNetworkNodeContainerBlockEntity<SimpleNetworkNode>
implements NetworkNodeExtendedMenuProvider<ResourceContainerData>,
PreviewProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(StorageMonitorBlockEntity.class);
    private static final String TAG_CLIENT_FILTER = "cf";
    private static final String TAG_CLIENT_AMOUNT = "ca";
    private static final String TAG_CLIENT_ACTIVE = "cac";
    private final FilterWithFuzzyMode filter;
    private final RateLimiter displayUpdateRateLimiter = RateLimiter.create((double)0.25);
    private final StorageMonitorInsertTracker insertTracker = new StorageMonitorInsertTracker();
    private long currentAmount;
    private boolean currentlyActive;
    private long lastExtractTime;

    public StorageMonitorBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntities.INSTANCE.getStorageMonitor(), pos, state, new SimpleNetworkNode(Platform.INSTANCE.getConfig().getStorageMonitor().getEnergyUsage()));
        ResourceContainer resourceContainer = ResourceContainerImpl.createForFilter(1);
        this.filter = FilterWithFuzzyMode.create(resourceContainer, () -> {
            this.method_5431();
            this.sendDisplayUpdate();
        });
    }

    @Override
    public void doWork() {
        super.doWork();
        if (this.field_11863 == null) {
            return;
        }
        this.trySendDisplayUpdate(this.field_11863);
    }

    private void trySendDisplayUpdate(class_1937 level) {
        long amount = this.getAmount();
        boolean active = ((SimpleNetworkNode)this.mainNetworkNode).isActive();
        if ((amount != this.currentAmount || active != this.currentlyActive) && this.displayUpdateRateLimiter.tryAcquire()) {
            this.sendDisplayUpdate(level, amount, active);
        }
    }

    private long getAmount() {
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return 0L;
        }
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return 0L;
        }
        return this.getAmount(network, configuredResource);
    }

    private long getAmount(Network network, ResourceKey configuredResource) {
        RootStorage rootStorage = network.getComponent(StorageNetworkComponent.class);
        if (!this.filter.isFuzzyMode() || !(rootStorage instanceof FuzzyRootStorage)) {
            return rootStorage.get(configuredResource);
        }
        FuzzyRootStorage fuzzyRootStorage = (FuzzyRootStorage)rootStorage;
        return fuzzyRootStorage.getFuzzy(configuredResource).stream().mapToLong(rootStorage::get).sum();
    }

    public void extract(class_3222 player) {
        if (this.field_11863 == null) {
            return;
        }
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return;
        }
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return;
        }
        boolean extracted = this.doExtract(this.field_11863, (class_1657)player, configuredResource, network);
        if (extracted) {
            this.lastExtractTime = System.currentTimeMillis();
        }
        if (!extracted && System.currentTimeMillis() - this.lastExtractTime > 250L) {
            this.tryAutocrafting(player, network, configuredResource);
        }
    }

    private void tryAutocrafting(class_3222 player, Network network, PlatformResourceKey configuredResource) {
        boolean autocraftable = network.getComponent(AutocraftingNetworkComponent.class).getOutputs().contains(configuredResource);
        if (autocraftable) {
            Platform.INSTANCE.getMenuOpener().openMenu(player, new AutocraftingStorageMonitorExtendedMenuProvider(configuredResource, this));
        }
    }

    private boolean doExtract(class_1937 level, class_1657 player, ResourceKey configuredResource, Network network) {
        boolean success = RefinedStorageApi.INSTANCE.getStorageMonitorExtractionStrategy().extract(configuredResource, !player.method_5715(), player, new PlayerActor(player), network);
        if (!success) {
            return false;
        }
        this.sendDisplayUpdate();
        level.method_8396(null, this.method_11016(), class_3417.field_15197, class_3419.field_15248, 0.2f, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7f + 1.0f) * 2.0f);
        return true;
    }

    public void insert(class_1657 player, class_1268 hand) {
        if (this.field_11863 != null && this.doInsert(player, hand)) {
            this.sendDisplayUpdate();
        }
    }

    private boolean doInsert(class_1657 player, class_1268 hand) {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return false;
        }
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return false;
        }
        class_1799 heldStack = player.method_5998(hand);
        if (heldStack.method_7960()) {
            return this.doInsertAll(player);
        }
        return this.doInsert(player, hand, heldStack, configuredResource, network);
    }

    private boolean doInsert(class_1657 player, class_1268 hand, class_1799 heldStack, ResourceKey configuredResource, Network network) {
        return RefinedStorageApi.INSTANCE.getStorageMonitorInsertionStrategy().insert(configuredResource, heldStack, new PlayerActor(player), network).map(result -> {
            this.insertTracker.trackInsertedItem(player.method_7334(), heldStack);
            player.method_6122(hand, result);
            return true;
        }).orElse(false);
    }

    private boolean doInsertAll(class_1657 player) {
        return this.insertTracker.getLastInsertedItem(player.method_7334()).map(item -> this.doInsertAll(player, (ItemResource)item)).orElse(false);
    }

    private boolean doInsertAll(class_1657 player, ItemResource lastInsertedItem) {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return false;
        }
        PlatformResourceKey configuredResource = this.getConfiguredResource();
        if (configuredResource == null) {
            return false;
        }
        boolean success = false;
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            success |= this.tryInsertSlot(player, lastInsertedItem, i, configuredResource, network);
        }
        return success;
    }

    private boolean tryInsertSlot(class_1657 player, ItemResource lastInsertedItem, int inventorySlotIndex, ResourceKey configuredResource, Network network) {
        class_1799 slot = player.method_31548().method_5438(inventorySlotIndex);
        if (slot.method_7960()) {
            return false;
        }
        ItemResource itemInSlot = ItemResource.ofItemStack(slot);
        if (!itemInSlot.equals(lastInsertedItem)) {
            return false;
        }
        return RefinedStorageApi.INSTANCE.getStorageMonitorInsertionStrategy().insert(configuredResource, slot, new PlayerActor(player), network).map(result -> {
            player.method_31548().method_5447(inventorySlotIndex, result);
            return true;
        }).orElse(false);
    }

    public boolean isFuzzyMode() {
        return this.filter.isFuzzyMode();
    }

    public void setFuzzyMode(boolean fuzzyMode) {
        this.filter.setFuzzyMode(fuzzyMode);
    }

    @Nullable
    public PlatformResourceKey getConfiguredResource() {
        return this.filter.getFilterContainer().getResource(0);
    }

    public long getCurrentAmount() {
        return this.currentAmount;
    }

    public boolean isCurrentlyActive() {
        return this.currentlyActive;
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.writeConfiguration(tag, provider);
        this.filter.save(tag, provider);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_CLIENT_FILTER) && tag.method_10545(TAG_CLIENT_AMOUNT) && tag.method_10545(TAG_CLIENT_ACTIVE)) {
            this.filter.getFilterContainer().fromTag(tag.method_10562(TAG_CLIENT_FILTER), provider);
            this.currentAmount = tag.method_10537(TAG_CLIENT_AMOUNT);
            this.currentlyActive = tag.method_10577(TAG_CLIENT_ACTIVE);
        }
        super.method_11014(tag, provider);
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        super.readConfiguration(tag, provider);
        this.filter.load(tag, provider);
    }

    @Override
    public ResourceContainerData getMenuData() {
        return ResourceContainerData.of(this.filter.getFilterContainer());
    }

    @Override
    public class_9142<class_9129, ResourceContainerData> getMenuCodec() {
        return ResourceContainerData.STREAM_CODEC;
    }

    public class_2561 method_5477() {
        return this.overrideName((class_2561)ContentNames.STORAGE_MONITOR);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
        return new StorageMonitorContainerMenu(syncId, player, this, this.filter.getFilterContainer());
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 tag = new class_2487();
        tag.method_10566(TAG_CLIENT_FILTER, (class_2520)this.filter.getFilterContainer().toTag(provider));
        tag.method_10544(TAG_CLIENT_AMOUNT, this.currentAmount);
        tag.method_10556(TAG_CLIENT_ACTIVE, this.currentlyActive);
        return tag;
    }

    private void sendDisplayUpdate() {
        if (this.field_11863 == null) {
            return;
        }
        this.sendDisplayUpdate(this.field_11863, this.getAmount(), ((SimpleNetworkNode)this.mainNetworkNode).isActive());
    }

    private void sendDisplayUpdate(class_1937 level, long amount, boolean active) {
        this.currentAmount = amount;
        this.currentlyActive = active;
        LOGGER.debug("Sending display update for storage monitor {} with amount {}", (Object)this.field_11867, (Object)amount);
        PlatformUtil.sendBlockUpdateToClient(level, this.field_11867);
    }

    @Override
    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return AbstractDirectionalBlock.didDirectionChange(oldBlockState, newBlockState);
    }

    @Override
    public CompletableFuture<Optional<Preview>> getPreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return Optional.ofNullable(((SimpleNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getPreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Optional<TreePreview>> getTreePreview(ResourceKey resource, long amount, CancellationToken cancellationToken) {
        return Optional.ofNullable(((SimpleNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getTreePreview(resource, amount, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(Optional.empty()));
    }

    @Override
    public CompletableFuture<Long> getMaxAmount(ResourceKey resource, CancellationToken cancellationToken) {
        return Optional.ofNullable(((SimpleNetworkNode)this.mainNetworkNode).getNetwork()).map(network -> network.getComponent(AutocraftingNetworkComponent.class)).map(component -> component.getMaxAmount(resource, cancellationToken)).orElseGet(() -> CompletableFuture.completedFuture(0L));
    }

    @Override
    public CompletableFuture<Optional<TaskId>> startTask(ResourceKey resource, long amount, Actor actor, boolean notify, CancellationToken cancellationToken) {
        Network network = ((SimpleNetworkNode)this.mainNetworkNode).getNetwork();
        if (network == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        return network.getComponent(AutocraftingNetworkComponent.class).startTask(resource, amount, actor, notify, cancellationToken);
    }
}

