/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlock;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlockEntity;
import com.refinedmods.refinedstorage.common.support.direction.BiDirection;
import com.refinedmods.refinedstorage.common.support.direction.BiDirectionType;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_827;
import org.joml.Quaternionf;

public class StorageMonitorBlockEntityRenderer
implements class_827<StorageMonitorBlockEntity> {
    private static final Quaternionf ROTATE_TO_FRONT = new Quaternionf().rotationY((float)Math.PI);
    private static final float FONT_SPACING = -0.23f;

    public void render(StorageMonitorBlockEntity blockEntity, float tickDelta, class_4587 poseStack, class_4597 vertexConsumers, int light, int overlay) {
        class_1937 level = blockEntity.method_10997();
        if (level == null) {
            return;
        }
        BiDirection direction = this.getDirection(blockEntity, level);
        if (direction == null) {
            return;
        }
        if (!blockEntity.isCurrentlyActive()) {
            return;
        }
        PlatformResourceKey resource = blockEntity.getConfiguredResource();
        if (resource == null) {
            return;
        }
        this.doRender(blockEntity.method_10997(), poseStack, vertexConsumers, direction, resource, blockEntity.getCurrentAmount());
    }

    private void doRender(class_1937 level, class_4587 poseStack, class_4597 vertexConsumers, BiDirection direction, ResourceKey resource, long amount) {
        ResourceRendering rendering = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass());
        this.doRender(poseStack, vertexConsumers, direction.getQuaternion(), rendering.formatAmount(amount), level, rendering, resource);
    }

    private void doRender(class_4587 poseStack, class_4597 renderTypeBuffer, Quaternionf rotation, String amount, class_1937 level, ResourceRendering resourceRendering, ResourceKey resource) {
        poseStack.method_22903();
        poseStack.method_22904(0.5, 0.5, 0.5);
        poseStack.method_22907(rotation);
        poseStack.method_22907(ROTATE_TO_FRONT);
        poseStack.method_22904(0.0, 0.05, 0.5);
        poseStack.method_22903();
        this.renderAmount(poseStack, renderTypeBuffer, amount);
        poseStack.method_22909();
        poseStack.method_22903();
        poseStack.method_46416(0.0f, 0.0f, 0.01f);
        resourceRendering.render(resource, poseStack, renderTypeBuffer, 0xF000F0, level);
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private void renderAmount(class_4587 poseStack, class_4597 renderTypeBuffer, String amount) {
        class_327 font = class_310.method_1551().field_1772;
        float width = font.method_1727(amount);
        poseStack.method_46416(0.0f, -0.23f, 0.02f);
        poseStack.method_22905(0.016129032f, -0.016129032f, 0.016129032f);
        poseStack.method_22905(0.5f, 0.5f, 0.0f);
        poseStack.method_46416(-0.5f * width, 0.0f, 0.5f);
        font.method_27521(amount, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.method_23760().method_23761(), renderTypeBuffer, class_327.class_6415.field_33993, 0, 0xF000F0);
    }

    @Nullable
    private BiDirection getDirection(StorageMonitorBlockEntity blockEntity, class_1937 level) {
        class_2680 state = level.method_8320(blockEntity.method_11016());
        if (state.method_26204() instanceof StorageMonitorBlock) {
            return (BiDirection)((Object)state.method_11654(BiDirectionType.INSTANCE.getProperty()));
        }
        return null;
    }
}

