/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.storagemonitor;

import com.mojang.authlib.GameProfile;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;

class StorageMonitorInsertTracker {
    private static final long MAX_DELAY = 500L;
    private final Map<UUID, Entry> entries = new HashMap<UUID, Entry>();

    StorageMonitorInsertTracker() {
    }

    void trackInsertedItem(GameProfile gameProfile, class_1799 stack) {
        this.entries.put(gameProfile.getId(), new Entry(System.currentTimeMillis(), ItemResource.ofItemStack(stack)));
    }

    Optional<ItemResource> getLastInsertedItem(GameProfile gameProfile) {
        Entry entry = this.entries.get(gameProfile.getId());
        if (entry == null) {
            return Optional.empty();
        }
        long time = System.currentTimeMillis();
        if (time - entry.time > 500L) {
            this.entries.remove(gameProfile.getId());
            return Optional.empty();
        }
        return Optional.of(entry.itemResource);
    }

    private record Entry(long time, ItemResource itemResource) {
    }
}

