/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.Sounds;
import com.refinedmods.refinedstorage.common.networking.AbstractCableBlockEntity;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.BlockEntityWithDrops;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.PlayerAwareBlockEntity;
import com.refinedmods.refinedstorage.common.support.containermenu.NetworkNodeMenuProvider;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3908;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public abstract class AbstractBaseBlock
extends class_2248 {
    private static final class_6862<class_1792> WRENCH_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"tools/wrench"));

    protected AbstractBaseBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590(this.getDefaultState());
    }

    protected class_2680 getDefaultState() {
        return (class_2680)this.method_9595().method_11664();
    }

    public class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        return this.tryOpenScreen(state, level, pos, player, hitResult.method_17784()).orElseGet(() -> super.method_55766(state, level, pos, player, hitResult));
    }

    @Nullable
    protected class_265 getScreenOpenableShape(class_2680 state) {
        return null;
    }

    private Optional<class_1269> tryOpenScreen(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_243 hit) {
        class_2586 blockEntity;
        class_265 screenOpenableShape = this.getScreenOpenableShape(state);
        if (screenOpenableShape != null) {
            boolean inBounds;
            class_238 aabb = screenOpenableShape.method_1107().method_996(pos);
            boolean inBoundsX = hit.field_1352 >= aabb.field_1323 && hit.field_1352 <= aabb.field_1320;
            boolean inBoundsY = hit.field_1351 >= aabb.field_1322 && hit.field_1351 <= aabb.field_1325;
            boolean inBoundsZ = hit.field_1350 >= aabb.field_1321 && hit.field_1350 <= aabb.field_1324;
            boolean bl = inBounds = inBoundsX && inBoundsY && inBoundsZ;
            if (!inBounds) {
                return Optional.empty();
            }
        }
        if ((blockEntity = level.method_8321(pos)) instanceof class_3908) {
            class_3908 provider = (class_3908)blockEntity;
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                this.tryOpenScreen(serverPlayer, provider);
            }
            return Optional.of(class_1269.field_5812);
        }
        return Optional.empty();
    }

    private void tryOpenScreen(class_3222 player, class_3908 menuProvider) {
        NetworkNodeMenuProvider networkNodeMenuProvider;
        if (menuProvider instanceof NetworkNodeMenuProvider && !(networkNodeMenuProvider = (NetworkNodeMenuProvider)menuProvider).canOpen(player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionToOpenMessage(player, (class_2561)this.method_9518());
            return;
        }
        Platform.INSTANCE.getMenuOpener().openMenu(player, menuProvider);
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_26204() != newState.method_26204() && !state.method_26204().getClass().equals(newState.method_26204().getClass())) {
            class_2586 blockEntity = level.method_8321(pos);
            if (blockEntity instanceof BlockEntityWithDrops) {
                BlockEntityWithDrops blockEntityDrops = (BlockEntityWithDrops)blockEntity;
                class_1264.method_17349((class_1937)level, (class_2338)pos, blockEntityDrops.getDrops());
                level.method_8455(pos, (class_2248)this);
            }
            super.method_9536(state, level, pos, newState, moved);
        }
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 state, @Nullable class_1309 entity, class_1799 stack) {
        super.method_9567(level, pos, state, entity, stack);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            class_2586 class_25862 = level.method_8321(pos);
            if (class_25862 instanceof PlayerAwareBlockEntity) {
                PlayerAwareBlockEntity playerAware = (PlayerAwareBlockEntity)class_25862;
                playerAware.setPlacedBy(player.method_7334().getId());
            }
        }
    }

    public final Optional<class_1269> tryUseWrench(class_2680 state, class_1937 level, class_3965 hitResult, class_1657 player, class_1268 hand) {
        class_3222 serverPlayer;
        boolean success;
        if (player.method_7325() || !level.method_8505(player, hitResult.method_17777())) {
            return Optional.empty();
        }
        class_1799 itemInHand = player.method_5998(hand);
        boolean holdingWrench = this.isWrench(itemInHand);
        if (!holdingWrench) {
            return Optional.empty();
        }
        boolean isWrenchingOwnBlock = state.method_26204() instanceof AbstractBaseBlock;
        if (!isWrenchingOwnBlock) {
            return Optional.empty();
        }
        if (player instanceof class_3222 && (success = this.dismantleOrRotate(state, level, hitResult, serverPlayer = (class_3222)player))) {
            level.method_8396(null, hitResult.method_17777(), Sounds.INSTANCE.getWrench(), class_3419.field_15245, 1.0f, 1.0f);
        }
        return Optional.of(class_1269.method_29236((boolean)level.method_8608()));
    }

    private boolean dismantleOrRotate(class_2680 state, class_1937 level, class_3965 hitResult, class_3222 player) {
        if (player.method_18276()) {
            return this.dismantle(state, level, hitResult, player);
        }
        return this.rotate(state, level, hitResult.method_17777(), hitResult.method_17780(), player);
    }

    private boolean rotate(class_2680 state, class_1937 level, class_2338 pos, class_2350 direction, class_3222 player) {
        NetworkNodeContainerProvider provider = Platform.INSTANCE.getContainerProvider(level, pos, direction);
        if (provider != null && !provider.canBuild(player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(player, (class_2561)IdentifierUtil.createTranslation("misc", "no_permission.build.rotate", this.method_9518()));
            return false;
        }
        class_2680 rotated = this.getRotatedBlockState(state, level, pos);
        level.method_8501(pos, rotated);
        return !state.equals(rotated);
    }

    protected class_2680 getRotatedBlockState(class_2680 state, class_1937 level, class_2338 pos) {
        return state.method_26186(class_2470.field_11463);
    }

    private boolean isWrench(class_1799 item) {
        return item.method_31573(WRENCH_TAG);
    }

    private boolean dismantle(class_2680 state, class_1937 level, class_3965 hitResult, class_3222 player) {
        NetworkNodeContainerProvider provider = Platform.INSTANCE.getContainerProvider(level, hitResult.method_17777(), hitResult.method_17780());
        if (provider != null && !provider.canBuild(player)) {
            RefinedStorageApi.INSTANCE.sendNoPermissionMessage(player, (class_2561)IdentifierUtil.createTranslation("misc", "no_permission.build.dismantle", this.method_9518()));
            return false;
        }
        class_2586 blockEntity = level.method_8321(hitResult.method_17777());
        class_1799 stack = Platform.INSTANCE.getCloneItemStack(state, level, hitResult, (class_1657)player);
        if (blockEntity != null) {
            if (!(blockEntity instanceof AbstractCableBlockEntity)) {
                blockEntity.method_38240(stack, (class_7225.class_7874)level.method_30349());
                class_9279.method_57452((class_9331)class_9334.field_49611, (class_1799)stack, CableConnections::stripTag);
            }
            level.method_8544(hitResult.method_17777());
        }
        level.method_8501(hitResult.method_17777(), class_2246.field_10124.method_9564());
        level.method_8649((class_1297)new class_1542(level, hitResult.method_17784().field_1352, hitResult.method_17784().field_1351, hitResult.method_17784().field_1350, stack));
        return true;
    }

    public final Optional<class_1269> tryUpdateColor(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        AbstractBaseBlock abstractBaseBlock = this;
        if (abstractBaseBlock instanceof ColorableBlock) {
            ColorableBlock colorableBlock = (ColorableBlock)((Object)abstractBaseBlock);
            return this.tryUpdateColor(colorableBlock.getBlockColorMap(), state, level, pos, player, hand);
        }
        return Optional.empty();
    }

    private Optional<class_1269> tryUpdateColor(BlockColorMap<?, ?> blockColorMap, class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand) {
        if (!player.method_18276()) {
            return Optional.empty();
        }
        return blockColorMap.updateColor(state, player.method_5998(hand), level, pos, player);
    }
}

