/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.support.PlayerInventoryListener;
import com.refinedmods.refinedstorage.common.support.PlayerInventorySlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.FilterSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.Property;
import com.refinedmods.refinedstorage.common.support.containermenu.PropertyType;
import com.refinedmods.refinedstorage.common.support.containermenu.ServerProperty;
import com.refinedmods.refinedstorage.common.support.containermenu.TransferManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public abstract class AbstractBaseContainerMenu
extends class_1703 {
    protected final TransferManager transferManager;
    @Nullable
    protected SlotReference disabledSlot;
    private final Map<PropertyType<?>, Property<?>> propertyMap = new HashMap();

    protected AbstractBaseContainerMenu(@Nullable class_3917<?> type, int syncId) {
        super(type, syncId);
        this.transferManager = Platform.INSTANCE.createTransferManager(this);
    }

    public <T> boolean hasProperty(PropertyType<T> type) {
        return this.propertyMap.containsKey(type);
    }

    public <T> ClientProperty<T> getProperty(PropertyType<T> type) {
        return (ClientProperty)Objects.requireNonNull(this.propertyMap.get(type), "Property not found");
    }

    public void receivePropertyChangeFromClient(class_2960 id, int newValue) {
        for (Map.Entry<PropertyType<?>, Property<?>> entry : this.propertyMap.entrySet()) {
            PropertyType<?> type = entry.getKey();
            if (!type.id().equals((Object)id)) continue;
            Property<?> property = entry.getValue();
            ((ServerProperty)property).method_17404(newValue);
        }
    }

    protected <T> void registerProperty(Property<T> property) {
        this.propertyMap.put(property.getType(), property);
        this.method_17362(property.getDataSlot());
    }

    protected void resetSlots() {
        this.field_7761.clear();
    }

    protected final void addPlayerInventory(class_1661 inventory, int inventoryX, int inventoryY) {
        this.addPlayerInventory(inventory, inventoryX, inventoryY, null);
    }

    protected final void addPlayerInventory(class_1661 inventory, int inventoryX, int inventoryY, @Nullable PlayerInventoryListener listener) {
        int x;
        int id = 9;
        for (int y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                int slotX = inventoryX + x * 18;
                int slotY = inventoryY + y * 18;
                boolean disabled = this.disabledSlot != null && this.disabledSlot.isDisabledSlot(id);
                class_1735 slot = disabled ? new DisabledSlot((class_1263)inventory, id, slotX, slotY) : new PlayerInventorySlot((class_1263)inventory, id, slotX, slotY, listener);
                this.method_7621(slot);
                ++id;
            }
        }
        id = 0;
        for (int i = 0; i < 9; ++i) {
            x = inventoryX + i * 18;
            int y = inventoryY + 4 + 54;
            boolean disabled = this.disabledSlot != null && this.disabledSlot.isDisabledSlot(id);
            class_1735 slot = disabled ? new DisabledSlot((class_1263)inventory, id, x, y) : new PlayerInventorySlot((class_1263)inventory, id, x, y, listener);
            this.method_7621(slot);
            ++id;
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        this.transferManager.transfer(index);
        return class_1799.field_8037;
    }

    public void method_7593(int id, int dragType, class_1713 clickType, class_1657 player) {
        class_1735 slot;
        class_1735 class_17352 = slot = id >= 0 ? this.method_7611(id) : null;
        if (this.isSwappingDisabledSlotWithNumberKeys(dragType, clickType)) {
            return;
        }
        if (slot instanceof FilterSlot) {
            class_1799 carried = player.field_7512.method_34255();
            if (carried.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else if (slot.method_7680(carried)) {
                slot.method_7673(carried.method_7972());
            }
            return;
        }
        if (slot instanceof DisabledSlot) {
            return;
        }
        super.method_7593(id, dragType, clickType, player);
    }

    public boolean method_7613(class_1799 stack, class_1735 slot) {
        if (slot instanceof FilterSlot || slot instanceof DisabledSlot) {
            return false;
        }
        return super.method_7613(stack, slot);
    }

    private boolean isSwappingDisabledSlotWithNumberKeys(int dragType, class_1713 clickType) {
        return this.disabledSlot != null && clickType == class_1713.field_7791 && this.disabledSlot.isDisabledSlot(dragType);
    }

    public void handleFilterSlotChange(int slotIndex, class_1799 stack) {
        FilterSlot filterSlot;
        if (slotIndex < 0 || slotIndex >= this.field_7761.size()) {
            return;
        }
        Object object = this.field_7761.get(slotIndex);
        if (object instanceof FilterSlot && (filterSlot = (FilterSlot)((Object)object)).method_7680(stack)) {
            filterSlot.method_7673(stack);
        }
    }
}

