/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.support.ResourceSlotRendering;
import com.refinedmods.refinedstorage.common.support.amount.ResourceAmountScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.MouseClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.SmallTextClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeItemClientTooltipComponent;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeSlot;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5481;
import net.minecraft.class_5684;
import net.minecraft.class_768;
import org.apiguardian.api.API;

public abstract class AbstractBaseScreen<T extends class_1703>
extends class_465<T> {
    protected static final int TITLE_MAX_WIDTH = 162;
    private static final SmallTextClientTooltipComponent CLICK_TO_CLEAR = new SmallTextClientTooltipComponent((class_2561)IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.click_to_clear"));
    private static final SmallTextClientTooltipComponent SHIFT_CLICK_TO_CLEAR = new SmallTextClientTooltipComponent((class_2561)IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.shift_click_to_clear"));
    private static final class_5684 EMPTY_FILTER = class_5684.method_32662((class_5481)IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.empty_filter").method_30937());
    private static final class_5684 EMPTY_UPGRADE_SLOT = class_5684.method_32662((class_5481)IdentifierUtil.createTranslationAsHeading("gui", "empty_upgrade_slot").method_30937());
    protected final TextMarquee titleMarquee;
    private final class_1661 playerInventory;
    private final List<class_768> exclusionZones = new ArrayList<class_768>();
    private int sideButtonY;
    @Nullable
    private List<class_5684> deferredTooltip;

    protected AbstractBaseScreen(T menu, class_1661 playerInventory, class_2561 title) {
        this(menu, playerInventory, new TextMarquee(title, 162));
    }

    protected AbstractBaseScreen(T menu, class_1661 playerInventory, TextMarquee title) {
        super(menu, playerInventory, title.getText());
        this.playerInventory = playerInventory;
        this.field_25267 = 7;
        this.field_25268 = 7;
        this.field_25269 = 7;
        this.titleMarquee = title;
    }

    protected int getSideButtonY() {
        return 6;
    }

    protected int getSideButtonX() {
        return this.field_2776 - 18 - 2;
    }

    protected void method_25426() {
        this.method_37067();
        super.method_25426();
        this.sideButtonY = this.getSideButtonY();
    }

    protected void method_37067() {
        super.method_37067();
        this.exclusionZones.clear();
    }

    protected abstract class_2960 getTexture();

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        graphics.method_25302(this.getTexture(), x, y, 0, 0, this.field_2792, this.field_2779);
        this.renderResourceSlots(graphics);
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51448().method_22909();
        int n = this.titleMarquee.getEffectiveWidth(this.field_22793);
        Objects.requireNonNull(this.field_22793);
        boolean hoveringOverTitle = this.method_2378(this.field_25267, this.field_25268, n, 9, mouseX, mouseY);
        this.titleMarquee.render(graphics, this.field_2776 + this.field_25267, this.field_2800 + this.field_25268, this.field_22793, hoveringOverTitle);
        graphics.method_51448().method_22903();
        graphics.method_51448().method_46416((float)this.field_2776, (float)this.field_2800, 0.0f);
        this.renderPlayerInventoryTitle(graphics);
    }

    protected final void renderPlayerInventoryTitle(class_332 graphics) {
        graphics.method_51439(this.field_22793, this.field_29347, this.field_25269, this.field_25270, 0x404040, false);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
    }

    protected void renderResourceSlots(class_332 graphics) {
        class_1703 class_17032 = this.field_2797;
        if (!(class_17032 instanceof AbstractResourceContainerMenu)) {
            return;
        }
        AbstractResourceContainerMenu resourceContainerMenu = (AbstractResourceContainerMenu)class_17032;
        for (ResourceSlot slot : resourceContainerMenu.getResourceSlots()) {
            ResourceSlotRendering.render(graphics, slot, this.field_2776, this.field_2800);
        }
    }

    public void addSideButton(AbstractSideButtonWidget button) {
        button.method_46421(this.getSideButtonX());
        button.method_46419(this.field_2800 + this.sideButtonY);
        this.exclusionZones.add(new class_768(button.method_46426(), button.method_46427(), button.method_25368(), button.method_25364()));
        this.sideButtonY += button.method_25364() + 2;
        this.method_37063((class_364)button);
    }

    @API(status=API.Status.INTERNAL)
    public List<class_768> getExclusionZones() {
        return this.exclusionZones;
    }

    protected void method_2380(class_332 graphics, int x, int y) {
        ResourceSlot resourceSlot;
        Object tooltip;
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof UpgradeSlot) {
            UpgradeSlot upgradeSlot = (UpgradeSlot)class_17352;
            tooltip = this.getUpgradeTooltip(this.field_2797.method_34255(), upgradeSlot);
            if (!tooltip.isEmpty()) {
                Platform.INSTANCE.renderTooltip(graphics, (List<class_5684>)tooltip, x, y);
                return;
            }
        }
        if ((tooltip = this.field_2787) instanceof ResourceSlot && this.canInteractWithResourceSlot(resourceSlot = (ResourceSlot)((Object)tooltip), x, y) && !(tooltip = this.getResourceSlotTooltip(this.field_2797.method_34255(), resourceSlot)).isEmpty()) {
            Platform.INSTANCE.renderTooltip(graphics, (List<class_5684>)tooltip, x, y);
            return;
        }
        if (this.deferredTooltip != null) {
            Platform.INSTANCE.renderTooltip(graphics, this.deferredTooltip, x, y);
            this.deferredTooltip = null;
        }
        super.method_2380(graphics, x, y);
    }

    public void setDeferredTooltip(@Nullable List<class_5684> deferredTooltip) {
        this.deferredTooltip = deferredTooltip;
    }

    private List<class_5684> getUpgradeTooltip(class_1799 carried, UpgradeSlot upgradeSlot) {
        if (!carried.method_7960() || upgradeSlot.method_7681()) {
            return Collections.emptyList();
        }
        ArrayList<class_5684> lines = new ArrayList<class_5684>();
        lines.add(EMPTY_UPGRADE_SLOT);
        for (UpgradeMapping upgrade : upgradeSlot.getAllowedUpgrades()) {
            lines.add(new UpgradeItemClientTooltipComponent(upgrade));
        }
        return lines;
    }

    public final List<class_5684> getResourceSlotTooltip(class_1799 carried, ResourceSlot slot) {
        PlatformResourceKey resource = slot.getResource();
        if (resource == null) {
            return this.getTooltipForEmptyResourceSlot(carried, slot);
        }
        return this.getResourceSlotTooltip(resource, slot);
    }

    protected List<class_5684> getResourceSlotTooltip(ResourceKey resource, ResourceSlot slot) {
        List<class_5684> tooltip = RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).getTooltip(resource).stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        if (!slot.isDisabled() && !slot.supportsItemSlotInteractions()) {
            this.addResourceSlotTooltips(slot, tooltip);
        }
        if (slot.supportsItemSlotInteractions()) {
            RefinedStorageApi.INSTANCE.getResourceContainerInsertStrategies().stream().flatMap(strategy -> strategy.getConversionInfo(resource, this.method_17577().method_34255()).stream()).map(conversionInfo -> MouseClientTooltipComponent.itemConversion(MouseClientTooltipComponent.Type.LEFT, conversionInfo.from(), conversionInfo.to(), null)).forEach(tooltip::add);
        }
        return tooltip;
    }

    private List<class_5684> getTooltipForEmptyResourceSlot(class_1799 carried, ResourceSlot slot) {
        if (slot.isDisabled() || slot.supportsItemSlotInteractions()) {
            return Collections.emptyList();
        }
        ArrayList<class_5684> tooltip = new ArrayList<class_5684>();
        tooltip.add(EMPTY_FILTER);
        tooltip.addAll(this.getResourceSlotHelpTooltip(carried, slot));
        tooltip.add(HelpClientTooltipComponent.create(slot.getHelpText()));
        return tooltip;
    }

    private List<class_5684> getResourceSlotHelpTooltip(class_1799 carried, ResourceSlot resourceSlot) {
        if (carried.method_7960()) {
            return Collections.emptyList();
        }
        ArrayList<class_5684> lines = new ArrayList<class_5684>();
        resourceSlot.getPrimaryResourceFactory().create(carried).ifPresent(primaryResourceInstance -> lines.add(MouseClientTooltipComponent.resource(MouseClientTooltipComponent.Type.LEFT, primaryResourceInstance.resource(), null)));
        for (ResourceFactory alternativeResourceFactory : resourceSlot.getAlternativeResourceFactories()) {
            Optional<ResourceAmount> result = alternativeResourceFactory.create(carried);
            result.ifPresent(alternativeResourceInstance -> lines.add(MouseClientTooltipComponent.resource(MouseClientTooltipComponent.Type.RIGHT, alternativeResourceInstance.resource(), null)));
        }
        return lines;
    }

    protected void addResourceSlotTooltips(ResourceSlot slot, List<class_5684> tooltip) {
        if (slot.canModifyAmount()) {
            tooltip.add(new SmallTextClientTooltipComponent(slot.getClickToConfigureAmountHelpTooltip()));
            tooltip.add(SHIFT_CLICK_TO_CLEAR);
        } else {
            tooltip.add(CLICK_TO_CLEAR);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        ResourceSlot resourceSlot;
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof ResourceSlot && !(resourceSlot = (ResourceSlot)class_17352).supportsItemSlotInteractions() && !resourceSlot.isDisabled() && this.canInteractWithResourceSlot(resourceSlot, mouseX, mouseY)) {
            class_1703 class_17032;
            if (!this.tryOpenResourceAmountScreen(resourceSlot) && (class_17032 = this.method_17577()) instanceof AbstractResourceContainerMenu) {
                AbstractResourceContainerMenu resourceMenu = (AbstractResourceContainerMenu)class_17032;
                resourceMenu.sendResourceSlotChange(this.field_2787.field_7874, clickedButton == 1);
            }
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    private boolean tryOpenResourceAmountScreen(ResourceSlot slot) {
        boolean canOpen;
        boolean isFilterSlot = slot.getResource() != null;
        boolean canModifyAmount = isFilterSlot && slot.canModifyAmount();
        boolean isNotTryingToRemoveFilter = !AbstractBaseScreen.method_25442();
        boolean isNotCarryingItem = this.method_17577().method_34255().method_7960();
        boolean bl = canOpen = isFilterSlot && canModifyAmount && isNotTryingToRemoveFilter && isNotCarryingItem;
        if (canOpen && this.field_22787 != null) {
            this.field_22787.method_1507(this.createResourceAmountScreen(slot));
        }
        return canOpen;
    }

    protected class_437 createResourceAmountScreen(ResourceSlot slot) {
        return new ResourceAmountScreen((class_437)this, this.playerInventory, slot);
    }

    protected boolean canInteractWithResourceSlot(ResourceSlot resourceSlot, double mouseX, double mouseY) {
        return true;
    }

    @Nullable
    @API(status=API.Status.INTERNAL)
    public PlatformResourceKey getHoveredResource() {
        class_1735 class_17352 = this.field_2787;
        if (class_17352 instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)class_17352;
            return resourceSlot.getResource();
        }
        return null;
    }

    @API(status=API.Status.INTERNAL)
    public int getLeftPos() {
        return this.field_2776;
    }

    @API(status=API.Status.INTERNAL)
    public int getTopPos() {
        return this.field_2800;
    }
}

