/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.network.AbstractBaseNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import javax.annotation.Nullable;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public abstract class AbstractCableLikeBlockEntity<T extends AbstractNetworkNode>
extends AbstractBaseNetworkNodeContainerBlockEntity<T> {
    protected CableConnections connections = CableConnections.NONE;

    protected AbstractCableLikeBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, T networkNode) {
        super(type, pos, state, networkNode);
    }

    @Override
    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        this.connections.writeToTag(tag);
    }

    @Override
    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        this.connections = CableConnections.fromTag(tag);
        if (this.field_11863 != null && this.field_11863.method_8608()) {
            Platform.INSTANCE.requestModelDataUpdateOnClient((class_1936)this.field_11863, this.method_11016(), true);
        }
    }

    public final void updateConnections() {
        this.connections = AbstractCableLikeBlockEntity.computeConnections(this.field_11863, this.method_11010(), this.field_11867);
        this.method_5431();
    }

    @Override
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.connections.writeToTag(super.method_16887(provider));
    }

    public CableConnections getConnections() {
        return this.connections;
    }

    private static CableConnections computeConnections(@Nullable class_1937 level, class_2680 state, class_2338 pos) {
        if (level == null) {
            return CableConnections.NONE;
        }
        class_2350 myDirection = AbstractDirectionalBlock.tryExtractDirection(state);
        boolean north = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, class_2350.field_11043, myDirection);
        boolean east = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, class_2350.field_11034, myDirection);
        boolean south = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, class_2350.field_11035, myDirection);
        boolean west = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, class_2350.field_11039, myDirection);
        boolean up = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, class_2350.field_11036, myDirection);
        boolean down = AbstractCableLikeBlockEntity.hasVisualConnection(state, level, pos, class_2350.field_11033, myDirection);
        return new CableConnections(north, east, south, west, up, down);
    }

    private static boolean hasVisualConnection(class_2680 blockState, class_1937 level, class_2338 pos, class_2350 direction, @Nullable class_2350 blacklistedDirection) {
        if (direction == blacklistedDirection) {
            return false;
        }
        class_2338 offsetPos = pos.method_10093(direction);
        NetworkNodeContainerProvider neighbor = Platform.INSTANCE.getContainerProvider(level, offsetPos, direction.method_10153());
        if (neighbor == null) {
            return false;
        }
        return neighbor.getContainers().stream().anyMatch(container -> container.canAcceptIncomingConnection(direction.method_10153(), blockState));
    }

    @Override
    public void method_31664(class_2680 newBlockState) {
        super.method_31664(newBlockState);
        if (this.field_11863 != null && !this.field_11863.method_8608()) {
            this.updateConnections();
            PlatformUtil.sendBlockUpdateToClient(this.field_11863, this.method_11016());
        }
    }
}

