/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.content.BlockConstants;
import com.refinedmods.refinedstorage.common.networking.CableConnections;
import com.refinedmods.refinedstorage.common.support.AbstractCableLikeBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.CableShapes;
import com.refinedmods.refinedstorage.common.support.direction.DefaultDirectionType;
import com.refinedmods.refinedstorage.common.support.direction.DirectionType;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_10;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;

public abstract class AbstractDirectionalCableBlock
extends AbstractDirectionalBlock<class_2350>
implements class_3737 {
    private final ConcurrentHashMap<DirectionalCacheShapeCacheKey, class_265> shapeCache;

    protected AbstractDirectionalCableBlock(ConcurrentHashMap<DirectionalCacheShapeCacheKey, class_265> shapeCache) {
        super(BlockConstants.CABLE_PROPERTIES);
        this.shapeCache = shapeCache;
    }

    @Override
    protected DirectionType<class_2350> getDirectionType() {
        return DefaultDirectionType.FACE_CLICKED;
    }

    @Override
    protected class_2680 getDefaultState() {
        return (class_2680)super.getDefaultState().method_11657((class_2769)class_2741.field_12508, (Comparable)Boolean.valueOf(false));
    }

    public boolean method_9579(class_2680 state, class_1922 blockGetter, class_2338 pos) {
        return (Boolean)state.method_11654((class_2769)class_2741.field_12508) == false;
    }

    public class_3610 method_9545(class_2680 state) {
        return Boolean.TRUE.equals(state.method_11654((class_2769)class_2741.field_12508)) ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{class_2741.field_12508});
    }

    protected boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    protected class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 neighborState, class_1936 level, class_2338 pos, class_2338 neighborPos) {
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof AbstractCableLikeBlockEntity) {
            AbstractCableLikeBlockEntity cable = (AbstractCableLikeBlockEntity)blockEntity;
            cable.updateConnections();
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                PlatformUtil.sendBlockUpdateToClient((class_1937)serverLevel, pos);
            }
        }
        if (level.method_8608()) {
            Platform.INSTANCE.requestModelDataUpdateOnClient(level, pos, false);
        }
        return super.method_9559(state, direction, neighborState, level, pos, neighborPos);
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2586 blockEntity = world.method_8321(pos);
        if (!(blockEntity instanceof AbstractCableLikeBlockEntity)) {
            return class_259.method_1077();
        }
        AbstractCableLikeBlockEntity cable = (AbstractCableLikeBlockEntity)blockEntity;
        CableConnections connections = cable.getConnections();
        class_2350 direction = (class_2350)this.getDirection(state);
        if (direction == null) {
            return CableShapes.getShape(connections);
        }
        DirectionalCacheShapeCacheKey directionalCacheKey = new DirectionalCacheShapeCacheKey(connections, direction);
        return this.shapeCache.computeIfAbsent(directionalCacheKey, this::computeShape);
    }

    private class_265 computeShape(DirectionalCacheShapeCacheKey cacheKey) {
        return class_259.method_1084((class_265)CableShapes.getShape(cacheKey.connections), (class_265)this.getExtensionShape(cacheKey.direction));
    }

    protected void method_9615(class_2680 state, class_1937 level, class_2338 pos, class_2680 oldState, boolean movedByPiston) {
        super.method_9615(state, level, pos, oldState, movedByPiston);
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof AbstractCableLikeBlockEntity) {
            AbstractCableLikeBlockEntity cable = (AbstractCableLikeBlockEntity)blockEntity;
            cable.updateConnections();
            PlatformUtil.sendBlockUpdateToClient(level, pos);
        }
    }

    @Override
    @Nullable
    protected class_265 getScreenOpenableShape(class_2680 state) {
        class_2350 direction = (class_2350)this.getDirection(state);
        if (direction == null) {
            return class_259.method_1073();
        }
        return this.getExtensionShape(direction);
    }

    protected abstract class_265 getExtensionShape(class_2350 var1);

    protected record DirectionalCacheShapeCacheKey(CableConnections connections, class_2350 direction) {
    }
}

