/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public final class FilterWithFuzzyMode {
    private static final String TAG_FUZZY_MODE = "fm";
    private static final String TAG_RESOURCE_FILTER = "rf";
    private final ResourceContainer filterContainer;
    @Nullable
    private final Runnable listener;
    @Nullable
    private final Consumer<Set<ResourceKey>> uniqueFilterListener;
    @Nullable
    private final Consumer<List<ResourceKey>> filterListener;
    private boolean fuzzyMode;

    private FilterWithFuzzyMode(ResourceContainer filterContainer, @Nullable Runnable listener, @Nullable Consumer<Set<ResourceKey>> uniqueFilterListener, @Nullable Consumer<List<ResourceKey>> filterListener) {
        this.filterContainer = filterContainer;
        this.listener = listener;
        this.uniqueFilterListener = uniqueFilterListener;
        this.filterListener = filterListener;
        this.filterContainer.setListener(this::filterContainerChanged);
    }

    private void filterContainerChanged() {
        this.notifyListeners();
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public ResourceContainer getFilterContainer() {
        return this.filterContainer;
    }

    public boolean isFuzzyMode() {
        return this.fuzzyMode;
    }

    public void setFuzzyMode(boolean fuzzyMode) {
        this.fuzzyMode = fuzzyMode;
        this.notifyListeners();
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public void load(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10545(TAG_RESOURCE_FILTER)) {
            this.filterContainer.fromTag(tag.method_10562(TAG_RESOURCE_FILTER), provider);
        }
        if (tag.method_10545(TAG_FUZZY_MODE)) {
            this.fuzzyMode = tag.method_10577(TAG_FUZZY_MODE);
        }
        this.notifyListeners();
    }

    private void notifyListeners() {
        if (this.uniqueFilterListener != null) {
            this.uniqueFilterListener.accept(this.filterContainer.getUniqueResources());
        }
        if (this.filterListener != null) {
            this.filterListener.accept(this.filterContainer.getResources());
        }
    }

    public void save(class_2487 tag, class_7225.class_7874 provider) {
        tag.method_10556(TAG_FUZZY_MODE, this.fuzzyMode);
        tag.method_10566(TAG_RESOURCE_FILTER, (class_2520)this.filterContainer.toTag(provider));
    }

    public UnaryOperator<ResourceKey> createNormalizer() {
        return value -> {
            if (!this.fuzzyMode) {
                return value;
            }
            if (value instanceof FuzzyModeNormalizer) {
                FuzzyModeNormalizer normalizer = (FuzzyModeNormalizer)((Object)value);
                return normalizer.normalize();
            }
            return value;
        };
    }

    public static FilterWithFuzzyMode create(ResourceContainer resourceContainer, @Nullable Runnable listener) {
        return new FilterWithFuzzyMode(resourceContainer, listener, null, null);
    }

    public static FilterWithFuzzyMode createAndListenForFilters(ResourceContainer resourceContainer, Runnable listener, Consumer<List<ResourceKey>> filterListener) {
        return new FilterWithFuzzyMode(resourceContainer, listener, null, filterListener);
    }

    public static FilterWithFuzzyMode createAndListenForUniqueFilters(ResourceContainer resourceContainer, Runnable listener, Consumer<Set<ResourceKey>> filterListener) {
        return new FilterWithFuzzyMode(resourceContainer, listener, filterListener, null);
    }
}

