/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.RecipeMatrixContainer;
import com.refinedmods.refinedstorage.common.util.ContainerUtil;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1731;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8059;
import net.minecraft.class_8566;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import net.minecraft.class_9697;

public class RecipeMatrix<T extends class_1860<I>, I extends class_9695> {
    private final Runnable listener;
    private final Supplier<@NullableType class_1937> levelSupplier;
    private final RecipeMatrixContainer matrix;
    private final class_1731 craftingResult = new class_1731();
    private final Function<RecipeMatrixContainer, I> inputProvider;
    private final class_3956<T> recipeType;
    @Nullable
    private class_8786<T> currentRecipe;

    public RecipeMatrix(Runnable listener, Supplier<@NullableType class_1937> levelSupplier, int width, int height, Function<RecipeMatrixContainer, I> inputProvider, class_3956<T> recipeType) {
        this.listener = listener;
        this.levelSupplier = levelSupplier;
        this.matrix = new RecipeMatrixContainer(this::matrixChanged, width, height);
        this.inputProvider = inputProvider;
        this.recipeType = recipeType;
    }

    public static RecipeMatrix<class_3955, class_9694> crafting(Runnable listener, Supplier<@NullableType class_1937> levelSupplier) {
        return new RecipeMatrix<class_3955, class_9694>(listener, levelSupplier, 3, 3, class_8566::method_59961, class_3956.field_17545);
    }

    public static RecipeMatrix<class_8059, class_9697> smithingTable(Runnable listener, Supplier<@NullableType class_1937> levelSupplier) {
        return new RecipeMatrix<class_8059, class_9697>(listener, levelSupplier, 3, 1, slots -> new class_9697(slots.method_5438(0), slots.method_5438(1), slots.method_5438(2)), class_3956.field_25388);
    }

    private void matrixChanged() {
        class_1937 level = this.levelSupplier.get();
        if (level == null) {
            return;
        }
        this.updateResult(level);
        this.listener.run();
    }

    public void clear(class_1937 level) {
        this.matrix.method_5448();
        this.updateResult(level);
    }

    public void updateResult(class_1937 level) {
        if (level.method_8608()) {
            return;
        }
        class_9695 input = (class_9695)this.inputProvider.apply(this.matrix);
        if (this.currentRecipe == null || !this.currentRecipe.comp_1933().method_8115(input, level)) {
            this.currentRecipe = this.loadRecipe(level);
        }
        if (this.currentRecipe == null) {
            this.setResult(null, class_1799.field_8037);
        } else {
            this.setResult(this.currentRecipe, this.currentRecipe.comp_1933().method_8116(input, (class_7225.class_7874)level.method_30349()));
        }
    }

    public RecipeMatrixContainer getMatrix() {
        return this.matrix;
    }

    public class_1731 getResult() {
        return this.craftingResult;
    }

    public boolean hasResult() {
        return !this.craftingResult.method_5438(0).method_7960();
    }

    private void setResult(@Nullable class_8786<?> recipe, class_1799 result) {
        this.craftingResult.method_7662(recipe);
        this.craftingResult.method_5447(0, result);
    }

    @Nullable
    private class_8786<T> loadRecipe(class_1937 level) {
        return level.method_8433().method_8132(this.recipeType, (class_9695)this.inputProvider.apply(this.matrix), level).orElse(null);
    }

    public class_2371<class_1799> getRemainingItems(@Nullable class_1937 level, class_1657 player, class_9694 input) {
        class_1860 class_18602;
        if (level == null || this.currentRecipe == null || !((class_18602 = this.currentRecipe.comp_1933()) instanceof class_3955)) {
            return class_2371.method_10211();
        }
        class_3955 craftingRecipe = (class_3955)class_18602;
        return Platform.INSTANCE.getRemainingCraftingItems(player, craftingRecipe, input);
    }

    public class_2487 writeToTag(class_7225.class_7874 provider) {
        return ContainerUtil.write((class_1263)this.matrix, provider);
    }

    public void readFromTag(class_2487 tag, class_7225.class_7874 provider) {
        ContainerUtil.read(tag, (class_1263)this.matrix, provider);
    }
}

