/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.root.RootStorage;
import com.refinedmods.refinedstorage.common.api.storage.PlayerActor;
import com.refinedmods.refinedstorage.common.support.CraftingMatrixContainerMenu;
import com.refinedmods.refinedstorage.common.support.network.ResourceSorters;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1715;
import net.minecraft.class_1799;

public class RecipeMatrixContainer
extends class_1715 {
    @Nullable
    private final Runnable listener;

    public RecipeMatrixContainer(@Nullable Runnable listener, int width, int height) {
        super((class_1703)new CraftingMatrixContainerMenu(listener), width, height);
        this.listener = listener;
    }

    public void changed() {
        if (this.listener != null) {
            this.listener.run();
        }
    }

    public boolean clearToPlayerInventory(class_1657 player) {
        boolean clearedAll = true;
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 matrixStack = this.method_5438(i);
            if (matrixStack.method_7960()) continue;
            if (player.method_31548().method_7394(matrixStack)) {
                this.method_5447(i, class_1799.field_8037);
                continue;
            }
            clearedAll = false;
        }
        return clearedAll;
    }

    public boolean clearIntoStorage(RootStorage rootStorage, class_1657 player) {
        boolean clearedAll = true;
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 matrixStack = this.method_5438(i);
            if (matrixStack.method_7960()) continue;
            class_1799 remainder = this.doInsert(matrixStack, player, rootStorage);
            if (!remainder.method_7960()) {
                clearedAll = false;
            }
            this.method_5447(i, remainder);
        }
        return clearedAll;
    }

    private class_1799 doInsert(class_1799 stack, class_1657 player, RootStorage rootStorage) {
        long inserted = rootStorage.insert(ItemResource.ofItemStack(stack), stack.method_7947(), Action.EXECUTE, new PlayerActor(player));
        long remainder = (long)stack.method_7947() - inserted;
        if (remainder == 0L) {
            return class_1799.field_8037;
        }
        return stack.method_46651((int)remainder);
    }

    public void transferRecipe(class_1657 player, @Nullable RootStorage rootStorage, List<List<ItemResource>> recipe) {
        boolean cleared;
        boolean bl = cleared = rootStorage == null ? this.clearToPlayerInventory(player) : this.clearIntoStorage(rootStorage, player);
        if (!cleared) {
            return;
        }
        Comparator<ResourceKey> sorter = ResourceSorters.create(rootStorage, player.method_31548());
        for (int i = 0; i < this.method_5439() && i < recipe.size(); ++i) {
            List<ItemResource> possibilities = recipe.get(i);
            possibilities.sort(sorter);
            this.doTransferRecipe(i, possibilities, player, rootStorage);
        }
    }

    private void doTransferRecipe(int index, List<ItemResource> sortedPossibilities, class_1657 player, @Nullable RootStorage rootStorage) {
        for (ItemResource possibility : sortedPossibilities) {
            boolean extracted;
            boolean bl = extracted = rootStorage != null && rootStorage.extract(possibility, 1L, Action.EXECUTE, new PlayerActor(player)) == 1L;
            if (!extracted) {
                extracted = this.extractSingleItemFromPlayerInventory(player, possibility);
            }
            if (!extracted) continue;
            this.method_5447(index, possibility.toItemStack());
            return;
        }
    }

    private boolean extractSingleItemFromPlayerInventory(class_1657 player, ItemResource possibility) {
        class_1799 possibilityStack = possibility.toItemStack();
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_1799 playerStack = player.method_31548().method_5438(i);
            if (!class_1799.method_31577((class_1799)playerStack, (class_1799)possibilityStack)) continue;
            player.method_31548().method_5434(i, 1);
            return true;
        }
        return false;
    }
}

