/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support;

import com.refinedmods.refinedstorage.api.network.impl.node.task.DefaultSchedulingMode;
import com.refinedmods.refinedstorage.api.network.impl.node.task.RandomSchedulingMode;
import com.refinedmods.refinedstorage.api.network.impl.node.task.RoundRobinSchedulingMode;
import com.refinedmods.refinedstorage.api.network.node.SchedulingMode;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public enum SchedulingModeType {
    DEFAULT(0, "default"),
    ROUND_ROBIN(1, "round_robin"),
    RANDOM(2, "random");

    private static final String TAG_ROUND_ROBIN_INDEX = "rri";
    private final int id;
    private final class_5250 name;
    private final class_2561 help;

    private SchedulingModeType(int id, String name) {
        this.id = id;
        this.name = IdentifierUtil.createTranslation("gui", "scheduling_mode." + name);
        this.help = IdentifierUtil.createTranslation("gui", "scheduling_mode." + name + ".help");
    }

    public static SchedulingModeType getById(int id) {
        for (SchedulingModeType mode : SchedulingModeType.values()) {
            if (mode.id != id) continue;
            return mode;
        }
        return DEFAULT;
    }

    public class_5250 getName() {
        return this.name;
    }

    public class_2561 getHelpText() {
        return this.help;
    }

    public int getId() {
        return this.id;
    }

    public SchedulingMode createSchedulingMode(@Nullable class_2487 tag, RandomSchedulingMode.Randomizer randomizer, Runnable listener) {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new DefaultSchedulingMode();
            case 2 -> new RandomSchedulingMode(randomizer);
            case 1 -> this.createRoundRobinSchedulingMode(tag, listener);
        };
    }

    private RoundRobinSchedulingMode createRoundRobinSchedulingMode(@Nullable class_2487 tag, Runnable listener) {
        int index = tag != null ? tag.method_10550(TAG_ROUND_ROBIN_INDEX) : 0;
        return new RoundRobinSchedulingMode(new RoundRobinSchedulingMode.State(listener, index));
    }

    public void writeToTag(class_2487 tag, SchedulingMode schedulingMode) {
        if (schedulingMode instanceof RoundRobinSchedulingMode) {
            RoundRobinSchedulingMode roundRobin = (RoundRobinSchedulingMode)schedulingMode;
            tag.method_10569(TAG_ROUND_ROBIN_INDEX, roundRobin.getIndex());
        }
    }
}

