/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.autocrafting.patterngrid.AlternativesScreen;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.amount.ActionButton;
import com.refinedmods.refinedstorage.common.support.amount.ActionIcon;
import com.refinedmods.refinedstorage.common.support.amount.AmountOperations;
import com.refinedmods.refinedstorage.common.support.amount.AmountScreenConfiguration;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.joml.Vector3f;

public abstract class AbstractAmountScreen<T extends class_1703, N extends Number>
extends AbstractBaseScreen<T> {
    private static final class_5250 RESET_TEXT = IdentifierUtil.createTranslation("gui", "configure_amount.reset");
    private static final class_5250 CANCEL_TEXT = class_2561.method_43471((String)"gui.cancel");
    private static final int INCREMENT_BUTTON_WIDTH = 30;
    private static final int ACTION_BUTTON_HEIGHT = 20;
    private static final int ACTION_BUTTON_WIDTH = 58;
    private static final int ACTION_BUTTON_SPACING = 20;
    @Nullable
    protected ActionButton confirmButton;
    @Nullable
    protected ActionButton cancelButton;
    @Nullable
    protected class_342 amountField;
    @Nullable
    private final class_437 parent;
    private final AmountScreenConfiguration<N> configuration;
    private final AmountOperations<N> amountOperations;

    protected AbstractAmountScreen(T containerMenu, @Nullable class_437 parent, class_1661 playerInventory, class_2561 title, AmountScreenConfiguration<N> configuration, AmountOperations<N> amountOperations) {
        super(containerMenu, playerInventory, title);
        this.parent = parent;
        this.configuration = configuration;
        this.amountOperations = amountOperations;
    }

    @Override
    protected void method_25426() {
        super.method_25426();
        if (this.configuration.isActionButtonsEnabled()) {
            this.addActionButtons();
        }
        this.addAmountField();
        this.addIncrementButtons();
    }

    private void addActionButtons() {
        Vector3f pos = this.configuration.getActionButtonsStartPosition();
        if (this.configuration.isHorizontalActionButtons()) {
            int spacing = 3;
            this.addCancelButton((int)pos.x, (int)pos.y);
            class_4185 resetButton = this.addResetButton((int)pos.x + Objects.requireNonNull(this.cancelButton).method_25368() + 3, (int)pos.y);
            this.addConfirmButton((int)pos.x + this.cancelButton.method_25368() + 3 + resetButton.method_25368() + 3, (int)pos.y);
        } else {
            int spacing = 24;
            this.addResetButton((int)pos.x, (int)pos.y);
            this.addConfirmButton((int)pos.x, (int)pos.y + 24);
            this.addCancelButton((int)pos.x, (int)pos.y + 48);
        }
    }

    private class_4185 addResetButton(int x, int y) {
        int width = this.configuration.isHorizontalActionButtons() ? this.field_22793.method_27525((class_5348)RESET_TEXT) + 20 + 12 : 58;
        ActionButton button = new ActionButton(this.field_2776 + x, this.field_2800 + y, width, 20, (class_2561)RESET_TEXT, btn -> this.reset());
        button.setIcon(ActionIcon.RESET);
        return (class_4185)this.method_37063((class_364)button);
    }

    private void addConfirmButton(int x, int y) {
        int width = this.configuration.isHorizontalActionButtons() ? this.field_22793.method_27525((class_5348)this.configuration.getConfirmButtonText()) + 20 + 12 : 58;
        ActionButton button = new ActionButton(this.field_2776 + x, this.field_2800 + y, width, 20, this.configuration.getConfirmButtonText(), btn -> this.tryConfirmAndCloseToParent());
        button.setIcon(this.getConfirmButtonIcon());
        this.confirmButton = (ActionButton)this.method_37063((class_364)button);
    }

    @Nullable
    protected ActionIcon getConfirmButtonIcon() {
        return ActionIcon.SET;
    }

    private void addCancelButton(int x, int y) {
        int width = this.configuration.isHorizontalActionButtons() ? this.field_22793.method_27525((class_5348)CANCEL_TEXT) + 20 + 12 : 58;
        ActionButton button = new ActionButton(this.field_2776 + x, this.field_2800 + y, width, 20, (class_2561)CANCEL_TEXT, btn -> this.close());
        button.setIcon(ActionIcon.CANCEL);
        this.cancelButton = (ActionButton)this.method_37063((class_364)button);
    }

    private void addAmountField() {
        Vector3f pos = this.configuration.getAmountFieldPosition();
        String originalValue = this.amountField != null ? this.amountField.method_1882() : null;
        int n = this.field_2776 + (int)pos.x();
        int n2 = this.field_2800 + (int)pos.y();
        int n3 = this.configuration.getAmountFieldWidth() - 6;
        Objects.requireNonNull(this.field_22793);
        this.amountField = new class_342(this.field_22793, n, n2, n3, 9, (class_2561)class_2561.method_43473());
        this.amountField.method_1858(false);
        this.amountField.method_1868(0xFFFFFF);
        if (originalValue != null) {
            this.amountField.method_1852(originalValue);
            this.onAmountFieldChanged();
        } else if (this.configuration.getInitialAmount() != null) {
            this.updateAmount(this.configuration.getInitialAmount());
        }
        this.amountField.method_1862(true);
        this.amountField.method_1856(this instanceof AlternativesScreen);
        this.amountField.method_25365(true);
        this.amountField.method_1863(value -> this.onAmountFieldChanged());
        this.method_25395((class_364)this.amountField);
        this.method_37063((class_364)this.amountField);
    }

    protected final void updateAmount(N amount) {
        if (this.amountField == null) {
            return;
        }
        this.amountField.method_1852(this.amountOperations.format(amount));
    }

    protected void onAmountFieldChanged() {
        if (this.amountField == null) {
            return;
        }
        boolean valid = this.getAndValidateAmount().isPresent();
        if (this.confirmButton != null) {
            this.confirmButton.field_22763 = valid;
            this.confirmButton.setIcon(valid ? this.getConfirmButtonIcon() : ActionIcon.ERROR);
        } else {
            this.tryConfirm();
        }
        this.amountField.method_1868(valid ? 0xFFFFFF : 0xFF5555);
    }

    private void addIncrementButtons() {
        Vector3f incrementsTopPos = this.configuration.getIncrementsTopStartPosition();
        this.addIncrementButtons(this.configuration.getIncrementsTop(), this.field_2776 + (int)incrementsTopPos.x, this.field_2800 + (int)incrementsTopPos.y);
        Vector3f incrementsBottomPos = this.configuration.getIncrementsBottomStartPosition();
        this.addIncrementButtons(this.configuration.getIncrementsBottom(), this.field_2776 + (int)incrementsBottomPos.x, this.field_2800 + (int)incrementsBottomPos.y);
    }

    private void addIncrementButtons(int[] increments, int x, int y) {
        for (int i = 0; i < increments.length; ++i) {
            int increment = increments[i];
            int xx = x + 33 * i;
            this.method_37063((class_364)this.createIncrementButton(xx, y, increment));
        }
    }

    protected abstract boolean confirm(N var1);

    private class_4185 createIncrementButton(int x, int y, int increment) {
        class_5250 text = class_2561.method_43470((String)((increment > 0 ? "+" : "") + increment));
        return class_4185.method_46430((class_2561)text, btn -> this.changeAmount(increment)).method_46433(x, y).method_46437(30, 20).method_46431();
    }

    private void changeAmount(int delta) {
        if (this.amountField == null) {
            return;
        }
        this.getAndValidateAmount().ifPresentOrElse(oldAmount -> {
            int correctedDelta = this.correctDelta(oldAmount, delta);
            Number newAmount = this.amountOperations.changeAmount((Number)oldAmount, correctedDelta, (Number)this.configuration.getMinAmount(), (Number)this.configuration.getMaxAmount());
            this.updateAmount(newAmount);
        }, () -> this.updateAmount(this.amountOperations.changeAmount(null, delta, this.configuration.getMinAmount(), this.configuration.getMaxAmount())));
    }

    private int correctDelta(N oldAmount, int delta) {
        if (((Number)oldAmount).intValue() == 1 && delta > 1) {
            return delta - 1;
        }
        return delta;
    }

    public boolean method_25401(double x, double y, double z, double delta) {
        if (delta > 0.0) {
            this.changeAmount(1);
        } else {
            this.changeAmount(-1);
        }
        return super.method_25401(x, y, z, delta);
    }

    @Override
    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
        graphics.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
    }

    public boolean method_25400(char unknown1, int unknown2) {
        return this.amountField != null && this.amountField.method_25400(unknown1, unknown2) || super.method_25400(unknown1, unknown2);
    }

    public boolean method_25404(int key, int scanCode, int modifiers) {
        if (this.tryClose(key)) {
            return true;
        }
        if (this.amountField != null && (key == 257 || key == 335) && this.amountField.method_25370()) {
            this.tryConfirmAndCloseToParent();
            return true;
        }
        if (this.amountField != null && (this.amountField.method_25404(key, scanCode, modifiers) || this.amountField.method_20315())) {
            return true;
        }
        return super.method_25404(key, scanCode, modifiers);
    }

    protected final boolean tryClose(int key) {
        if (key == 256) {
            this.close();
            return true;
        }
        return false;
    }

    protected void reset() {
        if (this.amountField == null || this.configuration.getResetAmount() == null) {
            return;
        }
        this.updateAmount(this.configuration.getResetAmount());
    }

    private void tryConfirm() {
        this.getAndValidateAmount().ifPresent(this::confirm);
    }

    private void tryConfirmAndCloseToParent() {
        this.getAndValidateAmount().ifPresent(value -> {
            if (this.confirm(value)) {
                this.tryCloseToParent();
            }
        });
    }

    private boolean tryCloseToParent() {
        if (this.parent != null) {
            class_310.method_1551().method_1507(this.parent);
            return true;
        }
        return false;
    }

    public final void close() {
        if (!this.beforeClose()) {
            return;
        }
        if (!this.tryCloseToParent()) {
            this.method_25419();
        }
    }

    protected boolean beforeClose() {
        return true;
    }

    protected final Optional<N> getAndValidateAmount() {
        if (this.amountField == null) {
            return Optional.empty();
        }
        return this.amountOperations.parse(this.amountField.method_1882()).flatMap(amount -> this.amountOperations.validate((Number)amount, (Number)this.configuration.getMinAmount(), (Number)this.configuration.getMaxAmount()));
    }

    protected static class DefaultDummyContainerMenu
    extends class_1703 {
        protected DefaultDummyContainerMenu() {
            super(null, 0);
        }

        public class_1799 method_7601(class_1657 player, int i) {
            return class_1799.field_8037;
        }

        public boolean method_7597(class_1657 player) {
            return true;
        }
    }
}

