/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.amount;

import com.refinedmods.refinedstorage.common.support.amount.AmountOperations;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_3532;

public class DoubleAmountOperations
implements AmountOperations<Double> {
    public static final AmountOperations<Double> INSTANCE = new DoubleAmountOperations();
    private static final DecimalFormat DECIMAL_FORMAT;

    private DoubleAmountOperations() {
    }

    @Override
    public String format(Double value) {
        return DECIMAL_FORMAT.format(value);
    }

    @Override
    public Optional<Double> parse(String value) {
        try {
            return Optional.of(Double.parseDouble(value));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<Double> validate(Double amount, @Nullable Double minAmount, @Nullable Double maxAmount) {
        boolean minBoundOk = minAmount == null || amount >= minAmount;
        boolean maxBoundOk = maxAmount == null || amount <= maxAmount;
        return minBoundOk && maxBoundOk ? Optional.of(amount) : Optional.empty();
    }

    @Override
    public Double changeAmount(@Nullable Double current, int delta, @Nullable Double minAmount, @Nullable Double maxAmount) {
        if (current == null) {
            return class_3532.method_15350((double)delta, (double)Objects.requireNonNullElse(minAmount, Double.MIN_VALUE), (double)Objects.requireNonNullElse(maxAmount, Double.MAX_VALUE));
        }
        return class_3532.method_15350((double)(current + (double)delta), (double)Objects.requireNonNullElse(minAmount, Double.MIN_VALUE), (double)Objects.requireNonNullElse(maxAmount, Double.MAX_VALUE));
    }

    static {
        DecimalFormatSymbols initialAmountSymbols = new DecimalFormatSymbols(Locale.ROOT);
        initialAmountSymbols.setDecimalSeparator('.');
        DECIMAL_FORMAT = new DecimalFormat("##.###", initialAmountSymbols);
        DECIMAL_FORMAT.setGroupingUsed(false);
    }
}

