/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlot;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3917;

public abstract class AbstractResourceContainerMenu
extends AbstractBaseContainerMenu {
    @Nullable
    protected final class_1657 player;
    private final List<ResourceSlot> resourceSlots = new ArrayList<ResourceSlot>();

    protected AbstractResourceContainerMenu(@Nullable class_3917<?> type, int syncId, class_1657 player) {
        super(type, syncId);
        this.player = player;
    }

    protected AbstractResourceContainerMenu(@Nullable class_3917<?> type, int syncId) {
        super(type, syncId);
        this.player = null;
    }

    private Optional<ResourceSlot> getResourceSlot(int slotIndex) {
        if (slotIndex < 0 || slotIndex >= this.field_7761.size()) {
            return Optional.empty();
        }
        Object object = this.field_7761.get(slotIndex);
        if (object instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)((Object)object);
            return Optional.of(resourceSlot);
        }
        return Optional.empty();
    }

    public void handleResourceSlotUpdate(int slotIndex, @Nullable ResourceAmount resourceAmount) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.change(resourceAmount));
    }

    public void handleResourceFilterSlotUpdate(int slotIndex, PlatformResourceKey resource) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.setFilter(resource));
    }

    public void handleResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.change(this.method_34255(), tryAlternatives));
    }

    public void sendResourceSlotChange(int slotIndex, boolean tryAlternatives) {
        C2SPackets.sendResourceSlotChange(slotIndex, tryAlternatives);
    }

    public void handleResourceSlotAmountChange(int slotIndex, long amount) {
        this.getResourceSlot(slotIndex).ifPresent(slot -> slot.changeAmount(amount));
    }

    public void method_7623() {
        super.method_7623();
        if (this.player == null) {
            return;
        }
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            resourceSlot.broadcastChanges(this.player);
        }
    }

    public List<ResourceSlot> getResourceSlots() {
        return this.resourceSlots;
    }

    protected class_1735 method_7621(class_1735 slot) {
        if (slot instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)slot;
            this.resourceSlots.add(resourceSlot);
        }
        return super.method_7621(slot);
    }

    @Override
    protected void resetSlots() {
        super.resetSlots();
        this.resourceSlots.clear();
    }

    public void addToResourceSlotIfNotExisting(class_1799 stack) {
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            if (!resourceSlot.contains(stack)) continue;
            return;
        }
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            if (!resourceSlot.changeIfEmpty(stack)) continue;
            return;
        }
    }

    protected final boolean areAllResourceSlotsEmpty() {
        for (ResourceSlot resourceSlot : this.resourceSlots) {
            if (resourceSlot.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean method_7613(class_1799 stack, class_1735 slot) {
        if (slot instanceof ResourceSlot) {
            ResourceSlot resourceSlot = (ResourceSlot)slot;
            return resourceSlot.supportsItemSlotInteractions();
        }
        return super.method_7613(stack, slot);
    }

    @Override
    public void method_7593(int id, int dragType, class_1713 clickType, class_1657 p) {
        class_1799 result;
        ResourceSlot resourceSlot;
        class_1735 slot;
        class_1735 class_17352 = slot = id >= 0 ? this.method_7611(id) : null;
        if (slot instanceof ResourceSlot && (resourceSlot = (ResourceSlot)slot).supportsItemSlotInteractions() && !resourceSlot.isEmpty() && !this.method_34255().method_7960() && (result = resourceSlot.insertInto(this.method_34255())) != null) {
            this.method_34254(result);
            return;
        }
        super.method_7593(id, dragType, clickType, p);
    }
}

