/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceFactory;
import com.refinedmods.refinedstorage.common.support.containermenu.DisabledResourceSlot;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceSlotType;
import com.refinedmods.refinedstorage.common.support.packet.c2s.C2SPackets;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceSlot
extends class_1735 {
    private static final class_2561 CLICK_TO_CONFIGURE_AMOUNT = IdentifierUtil.createTranslationAsHeading("gui", "filter_slot.click_to_configure_amount");
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceSlot.class);
    protected final ResourceContainer resourceContainer;
    private final class_2561 helpText;
    private final ResourceSlotType type;
    @Nullable
    private ResourceAmount cachedResource;

    public ResourceSlot(ResourceContainer resourceContainer, int index, class_2561 helpText, int x, int y, ResourceSlotType type) {
        this(resourceContainer, (class_1263)new class_1277(resourceContainer.size()), index, helpText, x, y, type);
    }

    public ResourceSlot(ResourceContainer resourceContainer, class_1263 resourceContainerAsContainer, int index, class_2561 helpText, int x, int y, ResourceSlotType type) {
        super(resourceContainerAsContainer, index, x, y);
        this.resourceContainer = resourceContainer;
        this.helpText = helpText;
        this.cachedResource = resourceContainer.get(index);
        this.type = type;
    }

    public ResourceSlot forAmountScreen(int newX, int newY) {
        return new DisabledResourceSlot(this.resourceContainer, this.field_7871, this.method_34266(), this.helpText, newX, newY, this.type);
    }

    public boolean shouldRenderAmount() {
        if (this.type == ResourceSlotType.FILTER_WITH_AMOUNT) {
            return true;
        }
        if (this.type == ResourceSlotType.CONTAINER) {
            if (this.getResource() instanceof ItemResource) {
                return this.getAmount() == 1L;
            }
            return true;
        }
        return false;
    }

    public boolean isFilter() {
        return this.type == ResourceSlotType.FILTER || this.type == ResourceSlotType.FILTER_WITH_AMOUNT;
    }

    public boolean canModifyAmount() {
        return this.type == ResourceSlotType.FILTER_WITH_AMOUNT;
    }

    public boolean supportsItemSlotInteractions() {
        return this.type == ResourceSlotType.CONTAINER;
    }

    public boolean isDisabled() {
        return false;
    }

    @Nullable
    public PlatformResourceKey getResource() {
        return this.resourceContainer.getResource(this.method_34266());
    }

    public long getAmount() {
        return this.resourceContainer.getAmount(this.method_34266());
    }

    private class_1799 getStackRepresentation() {
        return this.resourceContainer.getStackRepresentation(this.method_34266());
    }

    public boolean isEmpty() {
        return this.resourceContainer.isEmpty(this.method_34266());
    }

    public void change(class_1799 stack, boolean tryAlternatives) {
        this.resourceContainer.change(this.method_34266(), stack, tryAlternatives);
    }

    public void change(@Nullable ResourceAmount resourceAmount) {
        if (resourceAmount == null) {
            this.resourceContainer.remove(this.method_34266());
        } else {
            this.resourceContainer.set(this.method_34266(), resourceAmount);
        }
    }

    public void setFilter(PlatformResourceKey resource) {
        if (!this.isFilter() || !this.isValid(resource)) {
            return;
        }
        this.resourceContainer.set(this.method_34266(), new ResourceAmount(resource, resource.getResourceType().normalizeAmount(1.0)));
    }

    public boolean isValid(ResourceKey resource) {
        return this.resourceContainer.isValid(resource);
    }

    public boolean changeIfEmpty(class_1799 stack) {
        if (!this.isEmpty()) {
            return false;
        }
        this.resourceContainer.change(this.method_34266(), stack, false);
        return true;
    }

    public void changeAmount(long amount) {
        if (this.type != ResourceSlotType.FILTER_WITH_AMOUNT) {
            return;
        }
        this.resourceContainer.setAmount(this.method_34266(), amount);
    }

    public void changeAmountOnClient(double amount) {
        PlatformResourceKey resource = this.getResource();
        if (resource == null) {
            return;
        }
        long normalizedAmount = resource.getResourceType().normalizeAmount(amount);
        C2SPackets.sendResourceSlotAmountChange(this.field_7874, normalizedAmount);
    }

    public boolean contains(class_1799 stack) {
        return class_1799.method_7973((class_1799)stack, (class_1799)this.getStackRepresentation());
    }

    public boolean broadcastChanges(class_1657 player) {
        ResourceAmount currentResourceAmount = this.resourceContainer.get(this.method_34266());
        if (!Objects.equals(currentResourceAmount, this.cachedResource)) {
            LOGGER.debug("Resource slot {} has changed", (Object)this.method_34266());
            this.cachedResource = currentResourceAmount;
            this.broadcastChange((class_3222)player, currentResourceAmount);
            return true;
        }
        return false;
    }

    private void broadcastChange(class_3222 player, @Nullable ResourceAmount contents) {
        S2CPackets.sendResourceSlotUpdate(player, contents, this.field_7874);
    }

    public boolean method_7674(class_1657 player) {
        return this.supportsItemSlotInteractions();
    }

    public boolean method_7680(class_1799 stack) {
        return this.supportsItemSlotInteractions() && this.field_7871.method_5437(this.method_34266(), stack);
    }

    public double getDisplayAmount() {
        PlatformResourceKey resource = this.getResource();
        if (resource == null) {
            return 0.0;
        }
        return resource.getResourceType().getDisplayAmount(this.getAmount());
    }

    public double getMaxAmountWhenModifying() {
        PlatformResourceKey resource = this.getResource();
        if (!(resource instanceof PlatformResourceKey)) {
            return 0.0;
        }
        PlatformResourceKey platformResource = resource;
        return platformResource.getResourceType().getDisplayAmount(this.resourceContainer.getMaxAmount(resource));
    }

    public class_2561 getHelpText() {
        return this.helpText;
    }

    public ResourceFactory getPrimaryResourceFactory() {
        return this.resourceContainer.getPrimaryResourceFactory();
    }

    public Set<ResourceFactory> getAlternativeResourceFactories() {
        return this.resourceContainer.getAlternativeResourceFactories();
    }

    @Nullable
    public class_1799 insertInto(class_1799 carried) {
        ResourceAmount currentResourceAmount = this.resourceContainer.get(this.method_34266());
        if (currentResourceAmount == null) {
            return null;
        }
        return RefinedStorageApi.INSTANCE.getResourceContainerInsertStrategies().stream().flatMap(strategy -> strategy.insert(carried, currentResourceAmount).stream()).findFirst().map(result -> {
            this.resourceContainer.shrink(this.method_34266(), result.inserted());
            return result.container();
        }).orElse(null);
    }

    public class_2561 getClickToConfigureAmountHelpTooltip() {
        return CLICK_TO_CONFIGURE_AMOUNT;
    }
}

