/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.containermenu;

import com.refinedmods.refinedstorage.common.support.containermenu.AbstractResourceContainerMenu;
import com.refinedmods.refinedstorage.common.support.containermenu.ResourceInventoryDestination;
import com.refinedmods.refinedstorage.common.support.containermenu.TransferDestination;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class TransferManager {
    private final Map<TransferDestination, List<TransferDestination>> destinationMap = new HashMap<TransferDestination, List<TransferDestination>>();
    private final class_1703 containerMenu;
    private final Function<class_1263, TransferDestination> destinationFactory;

    public TransferManager(class_1703 containerMenu, Function<class_1263, TransferDestination> destinationFactory) {
        this.containerMenu = containerMenu;
        this.destinationFactory = destinationFactory;
    }

    public void addTransfer(class_1263 from, class_1263 to) {
        this.addTransfer(this.destinationFactory.apply(from), this.destinationFactory.apply(to));
    }

    private void addTransfer(TransferDestination from, TransferDestination to) {
        List destinationList = this.destinationMap.computeIfAbsent(from, k -> new LinkedList());
        destinationList.add(to);
    }

    public void addFilterTransfer(class_1263 from) {
        class_1703 class_17032 = this.containerMenu;
        if (!(class_17032 instanceof AbstractResourceContainerMenu)) {
            throw new UnsupportedOperationException(this.containerMenu.getClass().toString());
        }
        AbstractResourceContainerMenu resourceContainer = (AbstractResourceContainerMenu)class_17032;
        this.addTransfer(this.destinationFactory.apply(from), new ResourceInventoryDestination(resourceContainer));
    }

    public void addBiTransfer(class_1263 from, class_1263 to) {
        this.addTransfer(from, to);
        this.addTransfer(to, from);
    }

    public boolean transfer(int index) {
        class_1735 slot = this.containerMenu.method_7611(index);
        if (slot.method_7677().method_7960()) {
            return false;
        }
        TransferDestination key = this.destinationFactory.apply(slot.field_7871);
        List<TransferDestination> destinations = this.destinationMap.get(key);
        return destinations != null && this.transfer(slot, destinations);
    }

    private boolean transfer(class_1735 slot, List<TransferDestination> destinations) {
        class_1799 initial = slot.method_7677().method_7972();
        class_1799 remainder = this.doTransfer(initial, destinations);
        slot.method_7673(remainder);
        slot.method_7668();
        return initial.method_7947() != remainder.method_7947();
    }

    private class_1799 doTransfer(class_1799 initial, List<TransferDestination> destinations) {
        TransferDestination destination;
        class_1799 destinationRemainder;
        class_1799 remainder = initial;
        Iterator<TransferDestination> iterator = destinations.iterator();
        while (iterator.hasNext() && (destinationRemainder = (destination = iterator.next()).transfer(remainder)) != null) {
            remainder = destinationRemainder;
            if (!remainder.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remainder;
    }

    public void clear() {
        this.destinationMap.clear();
    }
}

