/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.direction;

import java.util.Locale;
import net.minecraft.class_2350;
import net.minecraft.class_3542;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public enum BiDirection implements class_3542
{
    NORTH(new Vector3f(0.0f, 0.0f, 0.0f), class_2350.field_11043),
    EAST(new Vector3f(0.0f, -90.0f, 0.0f), class_2350.field_11034),
    SOUTH(new Vector3f(0.0f, 180.0f, 0.0f), class_2350.field_11035),
    WEST(new Vector3f(0.0f, 90.0f, 0.0f), class_2350.field_11039),
    UP_NORTH(new Vector3f(90.0f, 0.0f, 180.0f), class_2350.field_11036),
    UP_EAST(new Vector3f(90.0f, 0.0f, -90.0f), class_2350.field_11036),
    UP_SOUTH(new Vector3f(90.0f, 0.0f, 0.0f), class_2350.field_11036),
    UP_WEST(new Vector3f(90.0f, 0.0f, 90.0f), class_2350.field_11036),
    DOWN_NORTH(new Vector3f(-90.0f, 0.0f, 0.0f), class_2350.field_11033),
    DOWN_EAST(new Vector3f(-90.0f, 0.0f, -90.0f), class_2350.field_11033),
    DOWN_SOUTH(new Vector3f(-90.0f, 0.0f, 180.0f), class_2350.field_11033),
    DOWN_WEST(new Vector3f(-90.0f, 0.0f, 90.0f), class_2350.field_11033);

    private final Vector3f vec;
    private final String name;
    private final Quaternionf quaternion;
    private final class_2350 direction;

    private BiDirection(Vector3f vec, class_2350 direction) {
        this.vec = vec;
        this.name = this.name().toLowerCase(Locale.ROOT);
        this.quaternion = new Quaternionf().rotateXYZ(vec.x() * ((float)Math.PI / 180), vec.y() * ((float)Math.PI / 180), vec.z() * ((float)Math.PI / 180));
        this.direction = direction;
    }

    public static BiDirection forDirection(class_2350 direction) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11034 -> EAST;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11036 -> UP_NORTH;
            case class_2350.field_11033 -> DOWN_NORTH;
        };
    }

    public static BiDirection forHorizontal(class_2350 horizontalDirection) {
        return switch (horizontalDirection) {
            case class_2350.field_11043 -> NORTH;
            case class_2350.field_11035 -> SOUTH;
            case class_2350.field_11039 -> WEST;
            case class_2350.field_11034 -> EAST;
            default -> throw new IllegalArgumentException(String.valueOf(horizontalDirection));
        };
    }

    public static BiDirection forUp(class_2350 verticalDirection) {
        return switch (verticalDirection) {
            case class_2350.field_11043 -> UP_NORTH;
            case class_2350.field_11035 -> UP_SOUTH;
            case class_2350.field_11039 -> UP_WEST;
            case class_2350.field_11034 -> UP_EAST;
            default -> throw new IllegalArgumentException(String.valueOf(verticalDirection));
        };
    }

    public static BiDirection forDown(class_2350 verticalDirection) {
        return switch (verticalDirection) {
            case class_2350.field_11043 -> DOWN_NORTH;
            case class_2350.field_11035 -> DOWN_SOUTH;
            case class_2350.field_11039 -> DOWN_WEST;
            case class_2350.field_11034 -> DOWN_EAST;
            default -> throw new IllegalArgumentException(String.valueOf(verticalDirection));
        };
    }

    public BiDirection rotate() {
        return switch (this.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> EAST;
            case 1 -> SOUTH;
            case 2 -> WEST;
            case 3 -> UP_NORTH;
            case 4 -> UP_EAST;
            case 5 -> UP_SOUTH;
            case 6 -> UP_WEST;
            case 7 -> DOWN_NORTH;
            case 8 -> DOWN_EAST;
            case 9 -> DOWN_SOUTH;
            case 10 -> DOWN_WEST;
            case 11 -> NORTH;
        };
    }

    public Vector3f getVec() {
        return this.vec;
    }

    public String method_15434() {
        return this.name;
    }

    public Quaternionf getQuaternion() {
        return this.quaternion;
    }

    public class_2350 asDirection() {
        return this.direction;
    }
}

