/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.exportingindicator;

import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.support.exportingindicator.ExportingIndicator;
import com.refinedmods.refinedstorage.common.support.packet.s2c.ExportingIndicatorUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.S2CPackets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.class_3222;

public class ExportingIndicators {
    @Nullable
    private final ResourceContainer filterContainer;
    private final List<ExportingIndicator> indicators;
    private final IntFunction<ExportingIndicator> indicatorProvider;
    private final boolean includeEmptySlots;

    public ExportingIndicators(List<ExportingIndicator> indicators) {
        this.filterContainer = null;
        this.indicators = indicators;
        this.indicatorProvider = i -> ExportingIndicator.NONE;
        this.includeEmptySlots = false;
    }

    public ExportingIndicators(ResourceContainer filterContainer, IntFunction<ExportingIndicator> indicatorProvider, boolean includeEmptySlots) {
        this.filterContainer = filterContainer;
        this.indicators = new ArrayList<ExportingIndicator>();
        this.includeEmptySlots = includeEmptySlots;
        int j = 0;
        for (int i = 0; i < filterContainer.size(); ++i) {
            if (filterContainer.isEmpty(i) && !includeEmptySlots) {
                this.indicators.add(ExportingIndicator.NONE);
                continue;
            }
            this.indicators.add(indicatorProvider.apply(j));
            ++j;
        }
        this.indicatorProvider = indicatorProvider;
    }

    public void detectChanges(class_3222 player) {
        if (this.filterContainer == null) {
            return;
        }
        int j = 0;
        List<ExportingIndicatorUpdatePacket.UpdatedIndicator> updatedIndicators = null;
        for (int i = 0; i < this.filterContainer.size(); ++i) {
            if (this.filterContainer.isEmpty(i) && !this.includeEmptySlots) {
                updatedIndicators = this.tryUpdateIndicator(i, ExportingIndicator.NONE, updatedIndicators);
                continue;
            }
            updatedIndicators = this.tryUpdateIndicator(i, this.indicatorProvider.apply(j), updatedIndicators);
            ++j;
        }
        if (updatedIndicators != null) {
            S2CPackets.sendExportingIndicatorUpdate(player, updatedIndicators);
        }
    }

    @Nullable
    private List<ExportingIndicatorUpdatePacket.UpdatedIndicator> tryUpdateIndicator(int idx, ExportingIndicator indicator, @Nullable List<ExportingIndicatorUpdatePacket.UpdatedIndicator> updatedIndicators) {
        if (this.indicators.get(idx) == indicator) {
            return updatedIndicators;
        }
        ArrayList<ExportingIndicatorUpdatePacket.UpdatedIndicator> result = updatedIndicators == null ? new ArrayList<ExportingIndicatorUpdatePacket.UpdatedIndicator>() : updatedIndicators;
        result.add(new ExportingIndicatorUpdatePacket.UpdatedIndicator(idx, indicator));
        this.set(idx, indicator);
        return result;
    }

    public List<ExportingIndicator> getAll() {
        return Collections.unmodifiableList(this.indicators);
    }

    public ExportingIndicator get(int idx) {
        return this.indicators.get(idx);
    }

    public void set(int idx, ExportingIndicator indicator) {
        this.indicators.set(idx, indicator);
    }

    public int size() {
        return this.indicators.size();
    }
}

