/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network;

import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.energy.EnergyNetworkComponent;
import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.network.node.NetworkNode;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.configurationcard.ConfigurationCardTarget;
import com.refinedmods.refinedstorage.common.api.support.network.AbstractNetworkNodeContainerBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemTargetBlockEntity;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.PlayerAwareBlockEntity;
import com.refinedmods.refinedstorage.common.support.RedstoneMode;
import com.refinedmods.refinedstorage.common.support.RedstoneModeSettings;
import com.refinedmods.refinedstorage.common.support.network.ColoredConnectionStrategy;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeTicker;
import com.refinedmods.refinedstorage.common.util.PlatformUtil;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.class_1275;
import net.minecraft.class_1657;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBaseNetworkNodeContainerBlockEntity<T extends AbstractNetworkNode>
extends AbstractNetworkNodeContainerBlockEntity<T>
implements NetworkItemTargetBlockEntity,
ConfigurationCardTarget,
PlayerAwareBlockEntity,
class_1275 {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractBaseNetworkNodeContainerBlockEntity.class);
    private static final String TAG_CUSTOM_NAME = "CustomName";
    private static final String TAG_PLACED_BY_PLAYER_ID = "pbpid";
    private static final String TAG_REDSTONE_MODE = "rm";
    private static final String TAG_DEBUG_NETWORK_ID = "dnid";
    private static final int ACTIVENESS_CHANGE_TICK_RATE = 20;
    protected NetworkNodeTicker ticker = NetworkNodeTicker.IMMEDIATE;
    private int activenessChangeTicks;
    @Nullable
    private class_2561 customName;
    @Nullable
    private UUID placedByPlayerId;
    private RedstoneMode redstoneMode = RedstoneMode.IGNORE;
    private int debugNetworkId = -1;

    protected AbstractBaseNetworkNodeContainerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state, T networkNode) {
        super(type, pos, state, networkNode);
    }

    @Override
    protected InWorldNetworkNodeContainer createMainContainer(T networkNode) {
        return RefinedStorageApi.INSTANCE.createNetworkNodeContainer(this, (NetworkNode)networkNode).connectionStrategy(new ColoredConnectionStrategy(() -> ((AbstractBaseNetworkNodeContainerBlockEntity)this).method_11010(), this.method_11016())).build();
    }

    protected boolean calculateActive() {
        boolean hasLevel;
        long energyUsage = ((AbstractNetworkNode)this.mainNetworkNode).getEnergyUsage();
        boolean bl = hasLevel = this.field_11863 != null && this.field_11863.method_8477(this.field_11867);
        boolean redstoneModeActive = !this.hasRedstoneMode() || this.redstoneMode.isActive(hasLevel && this.field_11863.method_49803(this.field_11867));
        return hasLevel && redstoneModeActive && ((AbstractNetworkNode)this.mainNetworkNode).getNetwork() != null && ((AbstractNetworkNode)this.mainNetworkNode).getNetwork().getComponent(EnergyNetworkComponent.class).getStored() >= energyUsage;
    }

    public void updateActiveness(class_2680 state, @Nullable class_2746 activenessProperty) {
        boolean activenessNeedsUpdate;
        boolean newActive = this.calculateActive();
        boolean nodeActivenessNeedsUpdate = newActive != ((AbstractNetworkNode)this.mainNetworkNode).isActive();
        boolean blockStateActivenessNeedsUpdate = activenessProperty != null && (Boolean)state.method_11654((class_2769)activenessProperty) != newActive;
        boolean bl = activenessNeedsUpdate = nodeActivenessNeedsUpdate || blockStateActivenessNeedsUpdate;
        if (activenessNeedsUpdate && this.activenessChangeTicks++ % 20 == 0) {
            if (nodeActivenessNeedsUpdate) {
                this.activenessChanged(newActive);
            }
            if (blockStateActivenessNeedsUpdate) {
                this.updateActivenessBlockState(state, activenessProperty, newActive);
            }
        }
    }

    protected void activenessChanged(boolean newActive) {
        LOGGER.debug("Activeness change for node at {}: {} -> {}", new Object[]{this.method_11016(), ((AbstractNetworkNode)this.mainNetworkNode).isActive(), newActive});
        ((AbstractNetworkNode)this.mainNetworkNode).setActive(newActive);
    }

    private void updateActivenessBlockState(class_2680 state, class_2746 activenessProperty, boolean active) {
        if (this.field_11863 != null) {
            LOGGER.debug("Sending block update at {} due to activeness change: {} -> {}", new Object[]{this.method_11016(), state.method_11654((class_2769)activenessProperty), active});
            this.field_11863.method_8501(this.method_11016(), (class_2680)state.method_11657((class_2769)activenessProperty, (Comparable)Boolean.valueOf(active)));
        }
    }

    public void doWork() {
        this.ticker.tick((AbstractNetworkNode)this.mainNetworkNode);
    }

    protected boolean doesBlockStateChangeWarrantNetworkNodeUpdate(class_2680 oldBlockState, class_2680 newBlockState) {
        return false;
    }

    public void method_31664(class_2680 newBlockState) {
        class_2680 oldBlockState = this.method_11010();
        super.method_31664(newBlockState);
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            this.initialize(serverLevel);
        }
        if (this.doesBlockStateChangeWarrantNetworkNodeUpdate(oldBlockState, newBlockState)) {
            this.containers.update(this.field_11863);
        }
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.initialize(serverLevel);
        }
    }

    protected final void initialize(class_3218 level) {
        class_2350 direction = AbstractDirectionalBlock.tryExtractDirection(this.method_11010());
        if (direction == null) {
            return;
        }
        this.initialize(level, direction);
    }

    protected void initialize(class_3218 level, class_2350 direction) {
    }

    @Override
    @Nullable
    public Network getNetworkForItem() {
        return ((AbstractNetworkNode)this.mainNetworkNode).getNetwork();
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (this.placedByPlayerId != null) {
            tag.method_25927(TAG_PLACED_BY_PLAYER_ID, this.placedByPlayerId);
        }
        this.writeConfiguration(tag, provider);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11014(tag, provider);
        if (tag.method_25928(TAG_PLACED_BY_PLAYER_ID)) {
            this.setPlacedBy(tag.method_25926(TAG_PLACED_BY_PLAYER_ID));
        }
        if (tag.method_10545(TAG_DEBUG_NETWORK_ID)) {
            this.debugNetworkId = tag.method_10550(TAG_DEBUG_NETWORK_ID);
            if (this.field_11863 != null) {
                Platform.INSTANCE.requestModelDataUpdateOnClient((class_1936)this.field_11863, this.method_11016(), true);
            }
        }
        this.readConfiguration(tag, provider);
    }

    public int getDebugNetworkId() {
        return this.debugNetworkId;
    }

    @Override
    public void writeConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        if (this.customName != null) {
            tag.method_10582(TAG_CUSTOM_NAME, class_2561.class_2562.method_10867((class_2561)this.customName, (class_7225.class_7874)provider));
        }
        if (this.hasRedstoneMode()) {
            tag.method_10569(TAG_REDSTONE_MODE, RedstoneModeSettings.getRedstoneMode(this.redstoneMode));
        }
    }

    @Override
    public void readConfiguration(class_2487 tag, class_7225.class_7874 provider) {
        if (tag.method_10573(TAG_CUSTOM_NAME, 8)) {
            this.customName = AbstractBaseNetworkNodeContainerBlockEntity.method_59894((String)tag.method_10558(TAG_CUSTOM_NAME), (class_7225.class_7874)provider);
        }
        if (this.hasRedstoneMode() && tag.method_10545(TAG_REDSTONE_MODE)) {
            this.redstoneMode = RedstoneModeSettings.getRedstoneMode(tag.method_10550(TAG_REDSTONE_MODE));
        }
    }

    protected boolean hasRedstoneMode() {
        return true;
    }

    private void verifyHasRedstoneMode() {
        if (!this.hasRedstoneMode()) {
            throw new IllegalStateException("Block has no redstone mode!");
        }
    }

    public RedstoneMode getRedstoneMode() {
        this.verifyHasRedstoneMode();
        return this.redstoneMode;
    }

    public void setRedstoneMode(RedstoneMode redstoneMode) {
        this.verifyHasRedstoneMode();
        this.redstoneMode = redstoneMode;
        this.method_5431();
    }

    protected void method_57568(class_2586.class_9473 componentInput) {
        super.method_57568(componentInput);
        this.customName = (class_2561)componentInput.method_58694(class_9334.field_49631);
    }

    protected void method_57567(class_9323.class_9324 components) {
        super.method_57567(components);
        components.method_57840(class_9334.field_49631, (Object)this.customName);
    }

    protected final void setCustomName(@Nullable class_2561 customName) {
        this.customName = customName;
    }

    @Nullable
    public final class_2561 method_5797() {
        return this.customName;
    }

    protected final class_2561 overrideName(class_2561 defaultName) {
        return this.customName == null ? defaultName : this.customName;
    }

    public final class_2561 method_5476() {
        return this.method_5477();
    }

    @Override
    public void setPlacedBy(UUID playerId) {
        this.placedByPlayerId = playerId;
        this.method_5431();
    }

    protected final class_1657 getFakePlayer(class_3218 serverLevel) {
        return Platform.INSTANCE.getFakePlayer(serverLevel, this.placedByPlayerId);
    }

    protected final boolean isPlacedBy(UUID playerId) {
        return Objects.equals(this.placedByPlayerId, playerId);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        if (!Platform.INSTANCE.getConfig().isDebug()) {
            return super.method_38235();
        }
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 provider) {
        if (!Platform.INSTANCE.getConfig().isDebug()) {
            return super.method_16887(provider);
        }
        class_2487 tag = super.method_16887(provider);
        tag.method_10569(TAG_DEBUG_NETWORK_ID, this.debugNetworkId);
        return tag;
    }

    public void updateDebugNetworkId() {
        int newNetworkId;
        int n = newNetworkId = ((AbstractNetworkNode)this.mainNetworkNode).getNetwork() == null ? -1 : ((AbstractNetworkNode)this.mainNetworkNode).getNetwork().hashCode();
        if (this.debugNetworkId != newNetworkId) {
            this.debugNetworkId = newNetworkId;
            PlatformUtil.sendBlockUpdateToClient(this.field_11863, this.method_11016());
        }
    }
}

