/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network;

import com.refinedmods.refinedstorage.common.api.support.network.ConnectionSink;
import com.refinedmods.refinedstorage.common.support.AbstractDirectionalBlock;
import com.refinedmods.refinedstorage.common.support.ColorableBlock;
import com.refinedmods.refinedstorage.common.support.network.SimpleConnectionStrategy;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;

public class ColoredConnectionStrategy
extends SimpleConnectionStrategy {
    protected final Supplier<class_2680> blockStateProvider;

    public ColoredConnectionStrategy(Supplier<class_2680> blockStateProvider, class_2338 origin) {
        super(origin);
        this.blockStateProvider = blockStateProvider;
    }

    @Override
    public void addOutgoingConnections(ConnectionSink sink) {
        class_2350 myDirection = AbstractDirectionalBlock.tryExtractDirection(this.blockStateProvider.get());
        if (myDirection == null) {
            super.addOutgoingConnections(sink);
            return;
        }
        for (class_2350 direction : class_2350.values()) {
            if (direction == myDirection) continue;
            sink.tryConnectInSameDimension(this.origin.method_10093(direction), direction.method_10153());
        }
    }

    @Override
    public boolean canAcceptIncomingConnection(class_2350 incomingDirection, class_2680 connectingState) {
        if (!this.colorsAllowConnecting(connectingState)) {
            return false;
        }
        class_2350 myDirection = AbstractDirectionalBlock.tryExtractDirection(this.blockStateProvider.get());
        if (myDirection != null) {
            return myDirection != incomingDirection;
        }
        return true;
    }

    protected final boolean colorsAllowConnecting(class_2680 connectingState) {
        class_2248 class_22482 = connectingState.method_26204();
        if (!(class_22482 instanceof ColorableBlock)) {
            return true;
        }
        ColorableBlock otherColorableBlock = (ColorableBlock)class_22482;
        ColorableBlock<?, ?> colorableBlock = this.getColor();
        if (colorableBlock == null) {
            return true;
        }
        return otherColorableBlock.getColor() == colorableBlock.getColor() || colorableBlock.canAlwaysConnect() || otherColorableBlock.canAlwaysConnect();
    }

    @Nullable
    private ColorableBlock<?, ?> getColor() {
        class_2248 class_22482 = this.blockStateProvider.get().method_26204();
        if (!(class_22482 instanceof ColorableBlock)) {
            return null;
        }
        ColorableBlock colorableBlock = (ColorableBlock)class_22482;
        return colorableBlock;
    }
}

