/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network;

import com.refinedmods.refinedstorage.api.network.ConnectionProvider;
import com.refinedmods.refinedstorage.api.network.Connections;
import com.refinedmods.refinedstorage.api.network.node.container.NetworkNodeContainer;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.network.InWorldNetworkNodeContainer;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.support.network.ConnectionSinkImpl;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4208;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectionProviderImpl
implements ConnectionProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionProviderImpl.class);
    private final class_1937 originLevel;

    public ConnectionProviderImpl(class_1937 originLevel) {
        this.originLevel = originLevel;
    }

    @Override
    public Connections findConnections(NetworkNodeContainer pivot, Set<NetworkNodeContainer> existingConnections) {
        InWorldNetworkNodeContainer currentContainer;
        Set<InWorldNetworkNodeContainer> existingInWorldConnections = existingConnections.stream().filter(InWorldNetworkNodeContainer.class::isInstance).map(InWorldNetworkNodeContainer.class::cast).collect(Collectors.toSet());
        LOGGER.debug("Finding connections for pivot {} with {} existing connections", (Object)pivot, (Object)existingConnections.size());
        ScanState scanState = new ScanState(existingInWorldConnections);
        this.addStartContainer(pivot, scanState);
        int requests = 0;
        while ((currentContainer = scanState.toCheck.poll()) != null) {
            this.visit(scanState, new ScanEntry(currentContainer));
            ++requests;
        }
        LOGGER.debug("Processed {} requests for pivot {} with {} found entries ({} removed and {} new)", new Object[]{requests, pivot, scanState.foundEntries.size(), scanState.removedEntries.size(), scanState.newEntries.size()});
        return scanState.toConnections();
    }

    private void addStartContainer(NetworkNodeContainer pivot, ScanState scanState) {
        if (!(pivot instanceof InWorldNetworkNodeContainer)) {
            return;
        }
        InWorldNetworkNodeContainer platformPivot = (InWorldNetworkNodeContainer)pivot;
        scanState.toCheck.add(platformPivot);
    }

    private void visit(ScanState state, ScanEntry entry) {
        if (state.foundEntries.contains(entry)) {
            return;
        }
        state.foundEntries.add(entry);
        if (!state.currentEntries.contains(entry)) {
            state.newEntries.add(entry);
        }
        state.removedEntries.remove(entry);
        List<InWorldNetworkNodeContainer> connections = this.findConnectionsAt(entry.getContainer());
        state.toCheck.addAll(connections);
    }

    private List<InWorldNetworkNodeContainer> findConnectionsAt(InWorldNetworkNodeContainer from) {
        class_4208 pos = from.getPosition();
        ConnectionSinkImpl sink = new ConnectionSinkImpl(pos);
        from.addOutgoingConnections(sink);
        ArrayList<InWorldNetworkNodeContainer> connections = new ArrayList<InWorldNetworkNodeContainer>();
        for (ConnectionSinkImpl.Connection connection : sink.getConnections()) {
            connections.addAll(this.getConnections(from, connection));
        }
        return connections;
    }

    private Set<InWorldNetworkNodeContainer> getConnections(InWorldNetworkNodeContainer from, ConnectionSinkImpl.Connection connection) {
        NetworkNodeContainerProvider provider = this.getContainerProviderSafely(connection.pos(), connection.incomingDirection());
        if (provider == null) {
            return Collections.emptySet();
        }
        if (connection.incomingDirection() == null) {
            return provider.getContainers().stream().filter(container -> this.isBlockAllowed(container.getBlockState(), connection)).collect(Collectors.toSet());
        }
        return provider.getContainers().stream().filter(container -> this.isBlockAllowed(container.getBlockState(), connection)).filter(container -> container.canAcceptIncomingConnection(connection.incomingDirection(), from.getBlockState())).collect(Collectors.toSet());
    }

    private boolean isBlockAllowed(class_2680 state, ConnectionSinkImpl.Connection connection) {
        if (connection.allowedBlockType() == null) {
            return true;
        }
        return state.method_26204().getClass().isAssignableFrom(connection.allowedBlockType());
    }

    @Override
    public List<NetworkNodeContainer> sortDeterministically(Set<NetworkNodeContainer> containers) {
        return containers.stream().sorted(Comparator.comparing(container -> ((InWorldNetworkNodeContainer)container).getLocalPosition())).toList();
    }

    @Nullable
    private NetworkNodeContainerProvider getContainerProviderSafely(class_4208 pos, @Nullable class_2350 direction) {
        MinecraftServer server = this.originLevel.method_8503();
        if (server == null) {
            return null;
        }
        class_3218 level = server.method_3847(pos.comp_2207());
        if (level == null) {
            return null;
        }
        return Platform.INSTANCE.getContainerProviderSafely((class_1937)level, pos.comp_2208(), direction);
    }

    private static class ScanState {
        private final Set<ScanEntry> currentEntries;
        private final Set<ScanEntry> foundEntries = new HashSet<ScanEntry>();
        private final Set<ScanEntry> newEntries = new HashSet<ScanEntry>();
        private final Set<ScanEntry> removedEntries;
        private final Queue<InWorldNetworkNodeContainer> toCheck = new ArrayDeque<InWorldNetworkNodeContainer>();

        ScanState(Set<InWorldNetworkNodeContainer> existingConnections) {
            this.currentEntries = ScanState.toScanEntries(existingConnections);
            this.removedEntries = new HashSet<ScanEntry>(this.currentEntries);
        }

        public Connections toConnections() {
            return new Connections(this.toContainers(this.foundEntries), this.toContainers(this.newEntries), this.toContainers(this.removedEntries));
        }

        private Set<NetworkNodeContainer> toContainers(Set<ScanEntry> entries) {
            return entries.stream().map(ScanEntry::getContainer).collect(Collectors.toSet());
        }

        private static Set<ScanEntry> toScanEntries(Set<InWorldNetworkNodeContainer> existingConnections) {
            return existingConnections.stream().map(ScanEntry::new).collect(Collectors.toSet());
        }
    }

    private static class ScanEntry {
        private final InWorldNetworkNodeContainer container;
        private final class_4208 pos;
        private final String name;

        ScanEntry(InWorldNetworkNodeContainer container) {
            this.container = container;
            this.pos = container.getPosition();
            this.name = container.getName();
        }

        private InWorldNetworkNodeContainer getContainer() {
            return this.container;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ScanEntry scanEntry = (ScanEntry)o;
            return Objects.equals(this.pos, scanEntry.pos) && Objects.equals(this.name, scanEntry.name);
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.name);
        }
    }
}

