/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.network.item;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.Network;
import com.refinedmods.refinedstorage.api.network.node.GraphNetworkComponent;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemContext;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemPlayerValidator;
import com.refinedmods.refinedstorage.common.api.support.network.item.NetworkItemTargetBlockEntity;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_4208;
import net.minecraft.class_5321;

class NetworkItemContextImpl
implements NetworkItemContext {
    private final class_1657 player;
    private final NetworkItemPlayerValidator.PlayerCoordinates coordinates;
    private final SlotReference slotReference;
    @Nullable
    private final class_4208 networkLocation;

    NetworkItemContextImpl(class_1657 player, SlotReference slotReference, @Nullable class_4208 networkLocation) {
        this.player = player;
        this.coordinates = new NetworkItemPlayerValidator.PlayerCoordinates((class_5321<class_1937>)player.method_37908().method_27983(), new class_243(player.method_19538().field_1352, player.method_19538().field_1351, player.method_19538().field_1350));
        this.slotReference = slotReference;
        this.networkLocation = networkLocation;
    }

    @Override
    public Optional<Network> resolveNetwork() {
        if (this.networkLocation == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.player.method_5682()).map(server -> server.method_3847(this.networkLocation.comp_2207())).filter(level -> level.method_8477(this.networkLocation.comp_2208())).map(level -> level.method_8321(this.networkLocation.comp_2208())).filter(NetworkItemTargetBlockEntity.class::isInstance).map(NetworkItemTargetBlockEntity.class::cast).map(NetworkItemTargetBlockEntity::getNetworkForItem).filter(this::isValid);
    }

    private boolean isValid(Network network) {
        return network.getComponent(GraphNetworkComponent.class).getContainers(NetworkItemPlayerValidator.class).stream().anyMatch(validator -> validator.isValid(this.coordinates));
    }

    @Override
    public boolean isActive() {
        return this.slotReference.resolve(this.player).flatMap(Platform.INSTANCE::getEnergyStorage).map(energyStorage -> energyStorage.getStored() > 0L).orElse(true);
    }

    @Override
    public void drainEnergy(long amount) {
        this.slotReference.resolve(this.player).flatMap(Platform.INSTANCE::getEnergyStorage).ifPresent(energyStorage -> energyStorage.extract(amount, Action.EXECUTE));
    }
}

