/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.registry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.common.api.support.registry.PlatformRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class PlatformRegistryImpl<T>
implements PlatformRegistry<T> {
    private static final String VALUE_NOT_PRESENT_ERROR = "Value must be present";
    private static final String ID_NOT_PRESENT_ERROR = "ID must be present";
    private final Map<class_2960, T> idToValueMap = new HashMap<class_2960, T>();
    private final Map<T, class_2960> valueToIdMap = new HashMap<T, class_2960>();
    private final List<T> order = new ArrayList<T>();
    private final List<T> viewList = Collections.unmodifiableList(this.order);
    private final Codec<T> codec = class_2960.field_25139.comapFlatMap(id -> this.get((class_2960)id).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown ID: " + String.valueOf(id))), value -> this.getId(value).orElseThrow());
    private final class_9139<class_9129, T> streamCodec = new class_9139<class_9129, T>(){

        public T decode(class_9129 buf) {
            return PlatformRegistryImpl.this.get(buf.method_10810()).orElseThrow();
        }

        public void encode(class_9129 buf, T value) {
            buf.method_10812(PlatformRegistryImpl.this.getId(value).orElseThrow());
        }
    };

    @Override
    public void register(class_2960 id, T value) {
        CoreValidations.validateNotNull(id, ID_NOT_PRESENT_ERROR);
        CoreValidations.validateNotNull(value, VALUE_NOT_PRESENT_ERROR);
        if (this.idToValueMap.containsKey(id) || this.order.contains(value)) {
            throw new IllegalArgumentException("Already registered");
        }
        this.idToValueMap.put(id, value);
        this.valueToIdMap.put(value, id);
        this.order.add(value);
    }

    @Override
    public Optional<class_2960> getId(T value) {
        CoreValidations.validateNotNull(value, VALUE_NOT_PRESENT_ERROR);
        return Optional.ofNullable(this.valueToIdMap.get(value));
    }

    @Override
    public Optional<T> get(class_2960 id) {
        CoreValidations.validateNotNull(id, ID_NOT_PRESENT_ERROR);
        return Optional.ofNullable(this.idToValueMap.get(id));
    }

    @Override
    public List<T> getAll() {
        return this.viewList;
    }

    @Override
    @Nullable
    public T nextOrNullIfLast(T value) {
        CoreValidations.validateNotNull(value, VALUE_NOT_PRESENT_ERROR);
        if (this.order.isEmpty()) {
            return null;
        }
        int index = this.order.indexOf(value);
        int nextIndex = index + 1;
        if (nextIndex >= this.order.size()) {
            return null;
        }
        return this.order.get(nextIndex);
    }

    @Override
    public Codec<T> codec() {
        return this.codec;
    }

    @Override
    public class_9139<class_9129, T> streamCodec() {
        return this.streamCodec;
    }
}

