/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceRendering;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;

public class FluidResourceRendering
implements ResourceRendering {
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###.###", DecimalFormatSymbols.getInstance(Locale.US));
    private final long bucketAmount;

    public FluidResourceRendering(long bucketAmount) {
        this.bucketAmount = bucketAmount;
    }

    @Override
    public String formatAmount(long amount, boolean withUnits) {
        return (!withUnits ? FluidResourceRendering.format(amount, this.bucketAmount) : FluidResourceRendering.formatWithUnits(amount, this.bucketAmount)) + "B";
    }

    @Override
    public class_2561 getDisplayName(ResourceKey resource) {
        if (!(resource instanceof FluidResource)) {
            return class_2561.method_43473();
        }
        FluidResource fluidResource = (FluidResource)resource;
        return Platform.INSTANCE.getFluidRenderer().getDisplayName(fluidResource);
    }

    @Override
    public List<class_2561> getTooltip(ResourceKey resource) {
        if (!(resource instanceof FluidResource)) {
            return Collections.emptyList();
        }
        FluidResource fluidResource = (FluidResource)resource;
        return Platform.INSTANCE.getFluidRenderer().getTooltip(fluidResource);
    }

    @Override
    public void render(ResourceKey resource, class_332 graphics, int x, int y) {
        if (!(resource instanceof FluidResource)) {
            return;
        }
        FluidResource fluidResource = (FluidResource)resource;
        Platform.INSTANCE.getFluidRenderer().render(graphics.method_51448(), x, y, fluidResource);
    }

    @Override
    public void render(ResourceKey resource, class_4587 poseStack, class_4597 renderTypeBuffer, int light, class_1937 level) {
        if (!(resource instanceof FluidResource)) {
            return;
        }
        FluidResource fluidResource = (FluidResource)resource;
        Platform.INSTANCE.getFluidRenderer().render(poseStack, renderTypeBuffer, light, fluidResource);
    }

    private static String formatWithUnits(long droplets, long bucketAmount) {
        double buckets = FluidResourceRendering.convertToBuckets(droplets, bucketAmount);
        return IdentifierUtil.formatWithUnits(buckets);
    }

    private static String format(long droplets, long bucketAmount) {
        double buckets = FluidResourceRendering.convertToBuckets(droplets, bucketAmount);
        return FORMATTER.format(buckets);
    }

    private static double convertToBuckets(long droplets, long bucketAmount) {
        return (double)droplets / (double)bucketAmount;
    }
}

