/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.refinedmods.refinedstorage.api.core.CoreValidations;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.FuzzyModeNormalizer;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceTag;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@API(status=API.Status.INTERNAL)
public record ItemResource(class_1792 item, class_9326 components) implements PlatformResourceKey,
FuzzyModeNormalizer
{
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemResource.class);

    public ItemResource(class_1792 item) {
        this(item, class_9326.field_49588);
    }

    public ItemResource(class_1792 item, class_9326 components) {
        this.item = CoreValidations.validateNotNull(item, "Item must not be null");
        this.components = CoreValidations.validateNotNull(components, "Components must not be null");
    }

    public class_1799 toItemStack() {
        return this.toItemStack(1L);
    }

    public class_1799 toItemStack(long amount) {
        if (amount > Integer.MAX_VALUE) {
            LOGGER.warn("Truncating too large amount for {} to fit into ItemStack {}", (Object)this, (Object)amount);
        }
        return new class_1799(class_7923.field_41178.method_47983((Object)this.item), (int)amount, this.components);
    }

    @Override
    public ResourceKey normalize() {
        return new ItemResource(this.item);
    }

    @Override
    public long getInterfaceExportLimit() {
        return this.item.method_7882();
    }

    @Override
    public long getProcessingPatternLimit() {
        return this.item.method_7882();
    }

    @Override
    public List<ResourceTag> getTags() {
        return class_7923.field_41178.method_47983((Object)this.item).method_40228().flatMap(tagKey -> class_7923.field_41178.method_40266(tagKey).stream()).map(tag -> new ResourceTag(tag.method_40251(), tag.method_40239().map(holder -> new ItemResource((class_1792)holder.comp_349())).toList())).toList();
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceTypes.ITEM;
    }

    public static ItemResource ofItemStack(class_1799 itemStack) {
        return new ItemResource(itemStack.method_7909(), itemStack.method_57380());
    }
}

