/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.resource;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceType;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import io.netty.handler.codec.DecoderException;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;

public final class ResourceCodecs {
    public static final MapCodec<ItemResource> ITEM_MAP_CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)class_7923.field_41178.method_39673().fieldOf("item").forGetter(ItemResource::item), (App)class_9326.field_49589.fieldOf("components").forGetter(ItemResource::components)).apply((Applicative)ins, ItemResource::new));
    public static final Codec<ItemResource> ITEM_CODEC = ITEM_MAP_CODEC.codec();
    public static final MapCodec<FluidResource> FLUID_MAP_CODEC = RecordCodecBuilder.mapCodec(ins -> ins.group((App)class_7923.field_41173.method_39673().fieldOf("fluid").forGetter(FluidResource::fluid), (App)class_9326.field_49589.fieldOf("components").forGetter(FluidResource::components)).apply((Applicative)ins, FluidResource::new));
    public static final Codec<FluidResource> FLUID_CODEC = FLUID_MAP_CODEC.codec();
    public static final Codec<PlatformResourceKey> CODEC = RefinedStorageApi.INSTANCE.getResourceTypeRegistry().codec().dispatch(PlatformResourceKey::getResourceType, ResourceType::getMapCodec);
    public static final Codec<ResourceAmount> AMOUNT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)CODEC.fieldOf("resource").forGetter(resourceAmount -> (PlatformResourceKey)resourceAmount.resource()), (App)Codec.LONG.fieldOf("amount").forGetter(ResourceAmount::amount)).apply((Applicative)instance, ResourceAmount::new));
    public static final Codec<Optional<ResourceAmount>> AMOUNT_OPTIONAL_CODEC = AMOUNT_CODEC.optionalFieldOf("resource").codec();
    public static final class_9139<class_9129, PlatformResourceKey> STREAM_CODEC = new class_9139<class_9129, PlatformResourceKey>(){

        public PlatformResourceKey decode(class_9129 buf) {
            class_2960 id = buf.method_10810();
            ResourceType resourceType = RefinedStorageApi.INSTANCE.getResourceTypeRegistry().get(id).orElseThrow();
            return (PlatformResourceKey)resourceType.getStreamCodec().decode((Object)buf);
        }

        public void encode(class_9129 buf, PlatformResourceKey resourceKey) {
            ResourceType resourceType = resourceKey.getResourceType();
            class_2960 id = RefinedStorageApi.INSTANCE.getResourceTypeRegistry().getId(resourceType).orElseThrow();
            buf.method_10812(id);
            resourceType.getStreamCodec().encode((Object)buf, (Object)resourceKey);
        }
    };
    public static final class_9139<class_9129, ResourceAmount> AMOUNT_STREAM_CODEC = class_9139.method_56437((buf, resourceAmount) -> {
        ResourceKey resourceKey = resourceAmount.resource();
        if (!(resourceKey instanceof PlatformResourceKey)) {
            throw new DecoderException("Cannot encode non-platform resource key");
        }
        PlatformResourceKey platformResourceKey = (PlatformResourceKey)resourceKey;
        STREAM_CODEC.encode(buf, (Object)platformResourceKey);
        buf.method_52974(resourceAmount.amount());
    }, buf -> {
        PlatformResourceKey resourceKey = (PlatformResourceKey)STREAM_CODEC.decode(buf);
        long amount = buf.readLong();
        return new ResourceAmount(resourceKey, amount);
    });
    public static final class_9139<class_9129, Optional<ResourceAmount>> AMOUNT_STREAM_OPTIONAL_CODEC = class_9135.method_56382(AMOUNT_STREAM_CODEC);
    public static final class_9139<class_9129, ItemResource> ITEM_STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), ItemResource::item, (class_9139)class_9326.field_49590, ItemResource::components, ItemResource::new);
    public static final class_9139<class_9129, FluidResource> FLUID_STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_56365((class_5321)class_7924.field_41270), FluidResource::fluid, (class_9139)class_9326.field_49590, FluidResource::components, FluidResource::new);

    private ResourceCodecs() {
    }
}

