/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.stretching;

import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.support.AbstractBaseContainerMenu;
import com.refinedmods.refinedstorage.common.support.AbstractBaseScreen;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSize;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeListener;
import com.refinedmods.refinedstorage.common.support.stretching.ScreenSizeSideButtonWidget;
import com.refinedmods.refinedstorage.common.support.widget.ScrollbarWidget;
import com.refinedmods.refinedstorage.common.support.widget.TextMarquee;
import javax.annotation.Nullable;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_364;

public abstract class AbstractStretchingScreen<T extends AbstractBaseContainerMenu>
extends AbstractBaseScreen<T> {
    protected static final int ROW_SIZE = 18;
    protected static final int TOP_HEIGHT = 19;
    private static final int INVENTORY_INCLUDING_TITLE_HEIGHT = 99;
    private static final int COLUMNS = 9;
    private static final int MIN_ROWS = 3;
    private static final int ROW_PADDING = 3;
    private int visibleRows;
    @Nullable
    private ScrollbarWidget scrollbar;

    protected AbstractStretchingScreen(T menu, class_1661 playerInventory, TextMarquee title) {
        super(menu, playerInventory, title);
    }

    protected AbstractStretchingScreen(T menu, class_1661 playerInventory, class_2561 title) {
        super(menu, playerInventory, title);
    }

    @Override
    protected void method_25426() {
        this.visibleRows = this.calculateVisibleRows();
        this.field_2779 = 19 + 18 * this.visibleRows + this.getBottomHeight();
        this.field_25270 = this.field_2779 - 99 + 4;
        this.resize();
        super.method_25426();
        this.scrollbar = new ScrollbarWidget(this.field_2776 + 174, this.field_2800 + 20, ScrollbarWidget.Type.NORMAL, this.visibleRows * 18 - 2);
        this.scrollbar.setListener(offset -> this.scrollbarChanged(this.visibleRows));
        this.method_25429((class_364)this.scrollbar);
        this.init(this.visibleRows);
        this.addSideButton(new ScreenSizeSideButtonWidget(this));
    }

    protected void init(int rows) {
    }

    protected final void resize() {
        ((ScreenSizeListener)((Object)((AbstractBaseContainerMenu)this.method_17577()))).resized(this.field_2779 - 99 + 17, 20, 20 + 18 * this.visibleRows - 2);
    }

    protected final int getScrollbarOffset() {
        if (this.scrollbar == null) {
            return 0;
        }
        int scrollbarOffset = (int)this.scrollbar.getOffset();
        if (!this.scrollbar.isSmoothScrolling()) {
            return scrollbarOffset * 18;
        }
        return scrollbarOffset;
    }

    protected void scrollbarChanged(int rows) {
    }

    @Override
    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.renderBackground(graphics, x, y);
        this.renderRows(graphics, mouseX, mouseY, x, y);
    }

    private void renderBackground(class_332 graphics, int x, int y) {
        graphics.method_25302(this.getTexture(), x, y, 0, 0, this.field_2792, 19);
        this.renderStretchingBackground(graphics, x, y + 19, this.visibleRows);
        graphics.method_25302(this.getTexture(), x, y + 19 + 18 * this.visibleRows, 0, this.getBottomV(), this.field_2792, this.getBottomHeight());
    }

    private void renderRows(class_332 graphics, int mouseX, int mouseY, int x, int y) {
        graphics.method_44379(x + 7, y + 19 + 1, x + 7 + 162, y + 19 + 1 + 18 * this.visibleRows - 2);
        this.renderRows(graphics, x, y, 19, this.visibleRows, mouseX, mouseY);
        graphics.method_44380();
    }

    protected abstract void renderRows(class_332 var1, int var2, int var3, int var4, int var5, int var6, int var7);

    protected abstract void renderStretchingBackground(class_332 var1, int var2, int var3, int var4);

    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(graphics, mouseX, mouseY, partialTicks);
        if (this.scrollbar != null) {
            this.scrollbar.method_25394(graphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int clickedButton) {
        if (this.scrollbar != null && this.scrollbar.method_25402(mouseX, mouseY, clickedButton)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, clickedButton);
    }

    public void method_16014(double mx, double my) {
        if (this.scrollbar != null) {
            this.scrollbar.method_16014(mx, my);
        }
        super.method_16014(mx, my);
    }

    public boolean method_25406(double mx, double my, int button) {
        return this.scrollbar != null && this.scrollbar.method_25406(mx, my, button) || super.method_25406(mx, my, button);
    }

    public boolean method_25401(double x, double y, double z, double delta) {
        boolean didScrollbar = this.scrollbar != null && !AbstractStretchingScreen.method_25442() && !AbstractStretchingScreen.method_25441() && this.scrollbar.method_25401(x, y, z, delta);
        return didScrollbar || super.method_25401(x, y, z, delta);
    }

    private int calculateVisibleRows() {
        int screenSpaceAvailable = this.field_22790 - 19 - this.getBottomHeight();
        int maxRows = this.getMaxRows();
        return Math.max(3, Math.min(screenSpaceAvailable / 18 - 3, maxRows));
    }

    protected final boolean isInStretchedArea(int y) {
        return y >= 19 && y < 19 + 18 * this.visibleRows;
    }

    private int getMaxRows() {
        return switch (Platform.INSTANCE.getConfig().getScreenSize()) {
            default -> throw new MatchException(null, null);
            case ScreenSize.STRETCH -> Platform.INSTANCE.getConfig().getMaxRowsStretch();
            case ScreenSize.SMALL -> 3;
            case ScreenSize.MEDIUM -> 5;
            case ScreenSize.LARGE -> 8;
            case ScreenSize.EXTRA_LARGE -> 12;
        };
    }

    protected final void updateScrollbar(int totalRows) {
        if (this.scrollbar == null) {
            return;
        }
        this.scrollbar.setEnabled(totalRows > this.visibleRows);
        int rowsExcludingVisibleOnes = totalRows - this.visibleRows;
        int maxOffset = this.scrollbar.isSmoothScrolling() ? rowsExcludingVisibleOnes * 18 + this.getScrollPanePadding() : rowsExcludingVisibleOnes;
        this.scrollbar.setMaxOffset(maxOffset);
    }

    protected abstract int getBottomHeight();

    protected abstract int getBottomV();

    protected int getScrollPanePadding() {
        return 0;
    }
}

