/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.tooltip;

import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageClientApi;
import com.refinedmods.refinedstorage.common.support.Sprites;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5684;

public class MouseClientTooltipComponent
implements class_5684 {
    private static final int PADDING = 4;
    private final Type type;
    private final IconRenderer iconRenderer;
    @Nullable
    private final String amount;

    private MouseClientTooltipComponent(Type type, IconRenderer iconRenderer, @Nullable String amount) {
        this.type = type;
        this.iconRenderer = iconRenderer;
        this.amount = amount;
    }

    public static class_5684 fluid(Type type, FluidResource fluidResource, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> Platform.INSTANCE.getFluidRenderer().render(graphics.method_51448(), x, y, fluidResource), amount);
    }

    public static class_5684 item(Type type, class_1799 stack, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> graphics.method_51427(stack, x, y), amount);
    }

    public static class_5684 itemWithDecorations(Type type, class_1799 stack, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> {
            graphics.method_51427(stack, x, y);
            graphics.method_51431(class_310.method_1551().field_1772, stack, x, y);
        }, amount);
    }

    public static class_5684 itemConversion(Type type, final class_1799 from, final class_1799 to, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, new IconRenderer(){

            @Override
            public void render(class_332 graphics, int x, int y) {
                graphics.method_51427(from, x, y);
                graphics.method_52706(Sprites.LIGHT_ARROW, x + 16 + 2, y, 22, 15);
                graphics.method_51427(to, x + 16 + 2 + 22 + 2, y);
            }

            @Override
            public int getWidth() {
                return 58;
            }
        }, amount);
    }

    public static class_5684 resource(Type type, ResourceKey resource, @Nullable String amount) {
        return new MouseClientTooltipComponent(type, (graphics, x, y) -> RefinedStorageClientApi.INSTANCE.getResourceRendering(resource.getClass()).render(resource, graphics, x, y), amount);
    }

    public int method_32661() {
        return 18;
    }

    public int method_32664(class_327 font) {
        return 13 + this.iconRenderer.getWidth();
    }

    public void method_32666(class_327 font, int x, int y, class_332 graphics) {
        graphics.method_52706(this.type.texture, x + this.type.leftPad, y, this.type.width, this.type.height);
        this.iconRenderer.render(graphics, x + 9 + 4, y);
        if (this.amount != null) {
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(0.0f, 0.0f, 200.0f);
            graphics.method_51433(font, this.amount, x + 9 + 4 + 16 - font.method_1727(this.amount), y + 9, 0xFFFFFF, true);
            poseStack.method_22909();
        }
    }

    public static enum Type {
        LEFT(IdentifierUtil.createIdentifier("left_mouse_button"), 0, 9, 13),
        RIGHT(IdentifierUtil.createIdentifier("right_mouse_button"), 2, 9, 13);

        private final class_2960 texture;
        private final int leftPad;
        private final int width;
        private final int height;

        private Type(class_2960 texture, int leftPad, int width, int height) {
            this.texture = texture;
            this.leftPad = leftPad;
            this.width = width;
            this.height = height;
        }
    }

    private static interface IconRenderer {
        public void render(class_332 var1, int var2, int var3);

        default public int getWidth() {
            return 16;
        }
    }
}

