/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.support.amount.PriorityScreen;
import com.refinedmods.refinedstorage.common.support.containermenu.ClientProperty;
import com.refinedmods.refinedstorage.common.support.widget.AbstractSideButtonWidget;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.IntConsumer;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;

public class StoragePrioritySideButtonWidget
extends AbstractSideButtonWidget {
    private static final class_5250 TITLE = IdentifierUtil.createTranslation("gui", "priority");
    private static final class_5250 INSERT_EXTRACT_TITLE = IdentifierUtil.createTranslation("gui", "insert_extract_priority");
    private static final class_5250 INSERT_TITLE = IdentifierUtil.createTranslation("gui", "insert_priority");
    private static final class_5250 EXTRACT_TITLE = IdentifierUtil.createTranslation("gui", "extract_priority");
    private static final class_2561 HELP = IdentifierUtil.createTranslation("gui", "priority.storage_help");
    private static final class_2960 SPRITE = IdentifierUtil.createIdentifier("widget/side_button/priority");
    private final ClientProperty<Integer> insertProperty;
    private final ClientProperty<Integer> extractProperty;

    public StoragePrioritySideButtonWidget(ClientProperty<Integer> insertProperty, ClientProperty<Integer> extractProperty, class_1661 playerInventory, class_437 parent) {
        super(StoragePrioritySideButtonWidget.createPressAction(insertProperty, extractProperty, playerInventory, parent));
        this.insertProperty = insertProperty;
        this.extractProperty = extractProperty;
    }

    private static class_4185.class_4241 createPressAction(ClientProperty<Integer> insertProperty, ClientProperty<Integer> extractProperty, class_1661 playerInventory, class_437 parent) {
        return btn -> {
            IntConsumer listener;
            int priority;
            class_5250 title;
            if (StoragePrioritySideButtonWidget.isModifyingInsert()) {
                title = INSERT_TITLE;
                priority = insertProperty.method_17407();
                listener = insertProperty::setValue;
            } else if (StoragePrioritySideButtonWidget.isModifyingExtract()) {
                title = EXTRACT_TITLE;
                priority = extractProperty.method_17407();
                listener = extractProperty::setValue;
            } else {
                title = INSERT_EXTRACT_TITLE;
                priority = insertProperty.method_17407();
                listener = value -> {
                    insertProperty.setValue(value);
                    extractProperty.setValue(value);
                };
            }
            class_310.method_1551().method_1507((class_437)new PriorityScreen(title, priority, listener, parent, playerInventory));
        };
    }

    @Override
    protected class_2960 getSprite() {
        return SPRITE;
    }

    @Override
    protected class_5250 getTitle() {
        return TITLE;
    }

    @Override
    protected List<class_5250> getSubText() {
        ArrayList<class_5250> subText = new ArrayList<class_5250>();
        boolean modifyingInsert = StoragePrioritySideButtonWidget.isModifyingInsert();
        boolean modifyingExtract = StoragePrioritySideButtonWidget.isModifyingExtract();
        if (Objects.equals(this.insertProperty.getValue(), this.extractProperty.getValue()) && !modifyingInsert && !modifyingExtract) {
            subText.add(IdentifierUtil.createTranslation("gui", "priority.insert_extract", this.insertProperty.getValue()).method_27692(class_124.field_1080));
        } else {
            subText.add(IdentifierUtil.createTranslation("gui", "priority.insert", this.insertProperty.getValue()).method_27692(modifyingInsert ? class_124.field_1054 : class_124.field_1080));
            subText.add(IdentifierUtil.createTranslation("gui", "priority.extract", this.extractProperty.getValue()).method_27692(!modifyingInsert && modifyingExtract ? class_124.field_1054 : class_124.field_1080));
        }
        return subText;
    }

    private static boolean isModifyingInsert() {
        return class_437.method_25441();
    }

    private static boolean isModifyingExtract() {
        return class_437.method_25443();
    }

    @Override
    protected class_2561 getHelpText() {
        return HELP;
    }
}

