/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.support.widget;

import com.refinedmods.refinedstorage.common.support.tooltip.SmallText;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5348;

public class TextMarquee {
    private final int maxWidth;
    private final int color;
    private final boolean dropShadow;
    private final boolean small;
    private class_2561 text;
    private int offset;
    private int stateTicks;
    private State state = State.MOVING_LEFT;

    public TextMarquee(class_2561 text, int maxWidth, int color, boolean dropShadow, boolean small) {
        this.text = text;
        this.maxWidth = maxWidth;
        this.color = color;
        this.dropShadow = dropShadow;
        this.small = small;
    }

    public TextMarquee(class_2561 text, int maxWidth) {
        this(text, maxWidth, 0x404040, false, false);
    }

    public int getEffectiveWidth(class_327 font) {
        return Math.min(this.maxWidth, font.method_27525((class_5348)this.text));
    }

    public void render(class_332 graphics, int x, int y, class_327 font, boolean hovering) {
        int width;
        if (!hovering) {
            this.offset = 0;
            this.state = State.MOVING_LEFT;
            this.stateTicks = 0;
        }
        if ((width = (int)((float)font.method_27525((class_5348)this.text) * (this.small ? SmallText.correctScale(0.5f) : 1.0f))) > this.maxWidth) {
            int overflow = width - this.maxWidth;
            if (hovering) {
                this.updateMarquee(overflow);
            }
            Objects.requireNonNull(font);
            graphics.method_44379(x, y, x + this.maxWidth, y + 9);
            if (this.small) {
                SmallText.render(graphics, font, this.text.method_30937(), x + this.offset, y, this.color, this.dropShadow, 0.5f);
            } else {
                graphics.method_51439(font, this.text, x + this.offset, y, this.color, this.dropShadow);
            }
            graphics.method_44380();
        } else if (this.small) {
            SmallText.render(graphics, font, this.text.method_30937(), x, y, this.color, this.dropShadow, 0.5f);
        } else {
            graphics.method_51439(font, this.text, x, y, this.color, this.dropShadow);
        }
    }

    private void updateMarquee(int overflow) {
        ++this.stateTicks;
        if (this.stateTicks % this.state.ticks == 0) {
            this.offset = this.state.updateOffset(this.offset);
            this.state = this.state.nextState(this.offset, overflow);
            this.stateTicks = 0;
        }
    }

    public class_2561 getText() {
        return this.text;
    }

    public void setText(class_2561 text) {
        this.text = text;
    }

    static enum State {
        MOVING_LEFT(2),
        MOVING_RIGHT(2),
        PAUSE(30);

        private final int ticks;

        private State(int ticks) {
            this.ticks = ticks;
        }

        int updateOffset(int currentOffset) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> currentOffset - 1;
                case 1 -> currentOffset + 1;
                case 2 -> currentOffset;
            };
        }

        State nextState(int currentOffset, int overflow) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    if (currentOffset > -overflow) {
                        yield MOVING_LEFT;
                    }
                    yield PAUSE;
                }
                case 1 -> {
                    if (currentOffset < 0) {
                        yield MOVING_RIGHT;
                    }
                    yield PAUSE;
                }
                case 2 -> currentOffset < 0 ? MOVING_RIGHT : MOVING_LEFT;
            };
        }
    }
}

