/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.Platform;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.api.support.resource.ResourceContainer;
import com.refinedmods.refinedstorage.common.api.support.slotreference.SlotReference;
import com.refinedmods.refinedstorage.common.api.upgrade.AbstractUpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.DataComponents;
import com.refinedmods.refinedstorage.common.support.containermenu.ExtendedMenuProvider;
import com.refinedmods.refinedstorage.common.support.containermenu.SingleAmountData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerData;
import com.refinedmods.refinedstorage.common.support.resource.ResourceContainerImpl;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeContainerMenu;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeState;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5632;
import net.minecraft.class_9129;
import net.minecraft.class_9142;
import net.minecraft.class_9334;

public class RegulatorUpgradeItem
extends AbstractUpgradeItem {
    private static final class_2561 HELP = IdentifierUtil.createTranslation("item", "regulator_upgrade.help");

    public RegulatorUpgradeItem(UpgradeRegistry registry) {
        super(new class_1792.class_1793(), registry, HELP);
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            RegulatorUpgradeState initialState = (RegulatorUpgradeState)stack.method_57825(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
            Platform.INSTANCE.getMenuOpener().openMenu(serverPlayer, new ExtendedMenuProviderImpl((class_2561)stack.method_57824(class_9334.field_49631), this.createResourceFilterContainer(stack, initialState), initialState.amount(), newAmount -> this.setAmount(stack, (double)newAmount), RefinedStorageApi.INSTANCE.createInventorySlotReference(player, hand)));
        }
        return class_1271.method_22427((Object)stack);
    }

    private ResourceContainer createResourceFilterContainer(class_1799 stack, RegulatorUpgradeState initialState) {
        ResourceContainer container = ResourceContainerImpl.createForFilter(1);
        container.setListener(() -> {
            RegulatorUpgradeState state = (RegulatorUpgradeState)stack.method_57825(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
            PlatformResourceKey resource = container.getResource(0);
            stack.method_57379(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)state.withResource(resource));
        });
        initialState.resource().ifPresent(initialResource -> container.set(0, new ResourceAmount((ResourceKey)initialResource, 1L)));
        return container;
    }

    @Override
    public Optional<class_5632> method_32346(class_1799 stack) {
        return Optional.of(new RegulatorTooltipComponent(this.getDestinations(), HELP, this.getConfiguredResource(stack)));
    }

    private void setAmount(class_1799 stack, double amount) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)stack.method_57825(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
        stack.method_57379(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)state.withAmount(amount));
    }

    public void setAmount(class_1799 regulatorStack, PlatformResourceKey resource, double amount) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)regulatorStack.method_57825(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)new RegulatorUpgradeState(amount, Optional.of(resource)));
        regulatorStack.method_57379(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)state);
    }

    @Override
    public long getEnergyUsage() {
        return Platform.INSTANCE.getConfig().getUpgrade().getRegulatorUpgradeEnergyUsage();
    }

    @Nullable
    private ResourceAmount getConfiguredResource(class_1799 stack) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)stack.method_57824(DataComponents.INSTANCE.getRegulatorUpgradeState());
        if (state == null) {
            return null;
        }
        return state.resource().map(resource -> {
            double amount = state.amount();
            long normalizedAmount = resource.getResourceType().normalizeAmount(amount);
            if (normalizedAmount <= 0L) {
                return null;
            }
            return new ResourceAmount((ResourceKey)resource, normalizedAmount);
        }).orElse(null);
    }

    public long getDesiredAmount(class_1799 stack, ResourceKey resource) {
        RegulatorUpgradeState state = (RegulatorUpgradeState)stack.method_57825(DataComponents.INSTANCE.getRegulatorUpgradeState(), (Object)RegulatorUpgradeState.EMPTY);
        if (state.resource().isEmpty()) {
            return 0L;
        }
        PlatformResourceKey configuredResource = state.resource().get();
        if (!configuredResource.equals(resource)) {
            return 0L;
        }
        double amount = state.amount();
        return configuredResource.getResourceType().normalizeAmount(amount);
    }

    private record ExtendedMenuProviderImpl(@Nullable class_2561 name, ResourceContainer resourceContainer, double amount, Consumer<Double> amountAcceptor, SlotReference slotReference) implements ExtendedMenuProvider<SingleAmountData>
    {
        @Override
        public SingleAmountData getMenuData() {
            return new SingleAmountData(Optional.of(this.slotReference), this.amount, ResourceContainerData.of(this.resourceContainer));
        }

        @Override
        public class_9142<class_9129, SingleAmountData> getMenuCodec() {
            return SingleAmountData.STREAM_CODEC;
        }

        public class_2561 method_5476() {
            return this.name == null ? ContentNames.REGULATOR_UPGRADE : this.name;
        }

        public class_1703 createMenu(int syncId, class_1661 inventory, class_1657 player) {
            return new RegulatorUpgradeContainerMenu(syncId, player, this.resourceContainer, this.amountAcceptor, this.slotReference);
        }
    }

    public record RegulatorTooltipComponent(Set<UpgradeMapping> destinations, class_2561 helpText, @Nullable ResourceAmount configuredResource) implements class_5632
    {
    }
}

