/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.api.network.impl.node.AbstractNetworkNode;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.RefinedStorageApi;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.support.network.NetworkNodeTicker;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeItem;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeContainerListener;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1277;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeContainer
extends class_1277
implements UpgradeState {
    private static final int DEFAULT_WORK_TICK_RATE = 9;
    private static final int DEFAULT_SIZE = 4;
    private static final Logger LOGGER = LoggerFactory.getLogger(UpgradeContainer.class);
    private final UpgradeDestination destination;
    private final UpgradeRegistry registry;
    private final Object2IntMap<UpgradeItem> index = new Object2IntOpenHashMap();
    @Nullable
    private final UpgradeContainerListener listener;
    private final int defaultWorkTickRate;
    private final ThrottledNetworkNodeTicker ticker;

    public UpgradeContainer(UpgradeDestination destination) {
        this(destination, null);
    }

    public UpgradeContainer(UpgradeDestination destination, int size) {
        this(size, destination, null, 9);
    }

    public UpgradeContainer(UpgradeDestination destination, @Nullable UpgradeContainerListener listener) {
        this(destination, listener, 9);
    }

    public UpgradeContainer(int size, UpgradeDestination destination, @Nullable UpgradeContainerListener listener) {
        this(4, destination, listener, 9);
    }

    public UpgradeContainer(UpgradeDestination destination, @Nullable UpgradeContainerListener listener, int defaultWorkTickRate) {
        this(4, destination, listener, defaultWorkTickRate);
    }

    public UpgradeContainer(int size, UpgradeDestination destination, @Nullable UpgradeContainerListener listener, int defaultWorkTickRate) {
        super(size);
        this.destination = destination;
        this.registry = RefinedStorageApi.INSTANCE.getUpgradeRegistry();
        this.method_5489(container -> this.updateIndex());
        this.method_5489(container -> this.notifyListener());
        this.listener = listener;
        this.defaultWorkTickRate = defaultWorkTickRate;
        this.ticker = new ThrottledNetworkNodeTicker(defaultWorkTickRate);
    }

    public NetworkNodeTicker getTicker() {
        return this.ticker;
    }

    public int method_5444() {
        return 1;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        UpgradeMapping upgrade = this.getAllowedUpgrades().stream().filter(u -> u.upgradeItem() == stack.method_7909()).findFirst().orElse(null);
        if (upgrade == null) {
            return false;
        }
        int currentCount = this.method_18861(stack.method_7909());
        if (currentCount >= upgrade.maxAmount()) {
            return false;
        }
        return super.method_5437(slot, stack);
    }

    public Set<UpgradeMapping> getAllowedUpgrades() {
        return this.registry.getByDestination(this.destination);
    }

    @Override
    public long getRegulatedAmount(ResourceKey resource) {
        for (int i = 0; i < this.method_5439(); ++i) {
            RegulatorUpgradeItem item;
            long regulatedAmount;
            class_1799 stack = this.method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof RegulatorUpgradeItem) || (regulatedAmount = (item = (RegulatorUpgradeItem)class_17922).getDesiredAmount(stack, resource)) <= 0L) continue;
            return regulatedAmount;
        }
        return 0L;
    }

    private void updateIndex() {
        LOGGER.debug("Updating upgrade index for {}", (Object)this.destination);
        this.index.clear();
        for (int i = 0; i < this.method_5439(); ++i) {
            this.updateIndex(i);
        }
    }

    private void updateIndex(int slotIndex) {
        class_1799 stack = this.method_5438(slotIndex);
        if (stack.method_7960()) {
            return;
        }
        class_1792 item = stack.method_7909();
        if (!(item instanceof UpgradeItem)) {
            return;
        }
        UpgradeItem upgradeItem = (UpgradeItem)item;
        this.index.put((Object)upgradeItem, this.index.getInt((Object)upgradeItem) + 1);
    }

    private void notifyListener() {
        if (this.listener == null) {
            return;
        }
        LOGGER.debug("Reconfiguring for upgrades");
        int amountOfSpeedUpgrades = this.getAmount(Items.INSTANCE.getSpeedUpgrade());
        this.ticker.workTickRate = this.defaultWorkTickRate - amountOfSpeedUpgrades * 2;
        this.listener.updateState(this, this.getEnergyUsage());
    }

    @Override
    public int getAmount(UpgradeItem upgradeItem) {
        return this.index.getInt((Object)upgradeItem);
    }

    public long getEnergyUsage() {
        long usage = 0L;
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            class_1792 class_17922 = stack.method_7909();
            if (!(class_17922 instanceof UpgradeItem)) continue;
            UpgradeItem upgradeItem = (UpgradeItem)class_17922;
            usage += upgradeItem.getEnergyUsage();
        }
        return usage;
    }

    public List<class_1799> getUpgrades() {
        ArrayList<class_1799> upgrades = new ArrayList<class_1799>();
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960()) continue;
            upgrades.add(stack.method_7972());
        }
        return upgrades;
    }

    public boolean addUpgrade(class_1799 upgrade) {
        return this.method_5491(upgrade).method_7960();
    }

    public class_2371<class_1799> getDrops() {
        class_2371 drops = class_2371.method_10211();
        for (int i = 0; i < this.method_5439(); ++i) {
            drops.add((Object)this.method_5438(i));
        }
        return drops;
    }

    private static class ThrottledNetworkNodeTicker
    implements NetworkNodeTicker {
        private int workTickRate;
        private int workTicks;

        private ThrottledNetworkNodeTicker(int workTickRate) {
            this.workTickRate = workTickRate;
        }

        @Override
        public void tick(AbstractNetworkNode networkNode) {
            if (this.workTicks++ % this.workTickRate == 0) {
                networkNode.doWork();
            }
        }
    }
}

