/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.upgrade;

import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeDestination;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeRegistry;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;

public class UpgradeRegistryImpl
implements UpgradeRegistry {
    private final Map<UpgradeDestination, Set<UpgradeMapping>> byDestination = new ConcurrentHashMap<UpgradeDestination, Set<UpgradeMapping>>();
    private final Map<class_1792, Set<UpgradeMapping>> byUpgradeItem = new ConcurrentHashMap<class_1792, Set<UpgradeMapping>>();

    @Override
    public UpgradeRegistry.DestinationBuilder forDestination(final UpgradeDestination destination) {
        return new UpgradeRegistry.DestinationBuilder(){

            @Override
            public UpgradeRegistry.DestinationBuilder add(class_1792 upgradeItem, int maxAmount) {
                UpgradeMapping mapping = UpgradeRegistryImpl.createMapping(destination, upgradeItem, maxAmount);
                UpgradeRegistryImpl.this.byDestination.computeIfAbsent(destination, key -> Collections.synchronizedSet(new LinkedHashSet())).add(mapping);
                UpgradeRegistryImpl.this.byUpgradeItem.computeIfAbsent(upgradeItem, key -> Collections.synchronizedSet(new LinkedHashSet())).add(mapping);
                return this;
            }
        };
    }

    private static UpgradeMapping createMapping(UpgradeDestination destination, class_1792 upgradeItem, int maxAmount) {
        class_1799 displayItemStack = new class_1799((class_1935)upgradeItem);
        return new UpgradeMapping(destination, upgradeItem, maxAmount, (class_2561)upgradeItem.method_7864(displayItemStack).method_27661().method_27693(" ").method_27693("(").method_27693(String.valueOf(maxAmount)).method_27693(")"), (class_2561)destination.getName().method_27661().method_27693(" ").method_27693("(").method_27693(String.valueOf(maxAmount)).method_27693(")"), displayItemStack);
    }

    @Override
    public Set<UpgradeMapping> getByDestination(UpgradeDestination destination) {
        return this.byDestination.getOrDefault(destination, Collections.emptySet());
    }

    @Override
    public Set<UpgradeMapping> getByUpgradeItem(class_1792 upgradeItem) {
        return this.byUpgradeItem.getOrDefault(upgradeItem, Collections.emptySet());
    }
}

