/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.common.util;

import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_6862;

public final class IdentifierUtil {
    public static final String MOD_ID = "refinedstorage";
    public static final class_5250 YES = class_2561.method_43471((String)"gui.yes");
    public static final class_5250 NO = class_2561.method_43471((String)"gui.no");
    private static final DecimalFormat FORMATTER_WITH_UNITS = new DecimalFormat("####0.#", DecimalFormatSymbols.getInstance(Locale.US));
    private static final DecimalFormat FORMATTER = new DecimalFormat("#,###", DecimalFormatSymbols.getInstance(Locale.US));

    private IdentifierUtil() {
    }

    public static class_2960 createIdentifier(String value) {
        return class_2960.method_60655((String)MOD_ID, (String)value);
    }

    public static String createTranslationKey(String category, String value) {
        return String.format("%s.%s.%s", category, MOD_ID, value);
    }

    public static class_5250 createTranslation(String category, String value) {
        return class_2561.method_43471((String)IdentifierUtil.createTranslationKey(category, value));
    }

    public static class_5250 createTranslation(String category, String value, Object ... args) {
        return class_2561.method_43469((String)IdentifierUtil.createTranslationKey(category, value), (Object[])args);
    }

    public static class_5250 createStoredWithCapacityTranslation(long stored, long capacity, double pct) {
        return IdentifierUtil.createTranslation("misc", "stored_with_capacity", class_2561.method_43470((String)(stored == Long.MAX_VALUE ? "\u221e" : IdentifierUtil.format(stored))).method_27692(class_124.field_1068), class_2561.method_43470((String)(capacity == Long.MAX_VALUE ? "\u221e" : IdentifierUtil.format(capacity))).method_27692(class_124.field_1068), class_2561.method_43470((String)String.valueOf((int)(pct * 100.0)))).method_27692(class_124.field_1080);
    }

    public static class_5250 createTranslationAsHeading(String category, String value) {
        return class_2561.method_43470((String)"<").method_10852((class_2561)IdentifierUtil.createTranslation(category, value)).method_27693(">").method_27692(class_124.field_1063);
    }

    public static String getTagTranslationKey(class_6862<?> key) {
        class_2960 registry = key.comp_326().method_29177();
        String fixedPath = registry.method_12832().replace('/', '.');
        if (registry.method_12836().equals("minecraft")) {
            return IdentifierUtil.getTagTranslationKey("tag.%s.".formatted(fixedPath), key.comp_327());
        }
        return IdentifierUtil.getTagTranslationKey("tag.%s.%s.".formatted(registry.method_12836(), fixedPath), key.comp_327());
    }

    private static String getTagTranslationKey(String prefix, class_2960 id) {
        String fixedPath = id.method_12832().replace('/', '.');
        return prefix + id.method_12836() + "." + fixedPath;
    }

    public static String formatWithUnits(double qty) {
        if (qty < 0.001) {
            return "0";
        }
        return switch ((int)Math.floor(Math.log10(qty) / 3.0)) {
            case -1 -> FORMATTER_WITH_UNITS.format(qty * 1000.0) + "m";
            case 0 -> FORMATTER_WITH_UNITS.format(qty >= 100.0 ? Math.floor(qty) : qty);
            case 1 -> FORMATTER_WITH_UNITS.format(qty >= 100000.0 ? Math.floor(qty / 1000.0) : qty / 1000.0) + "k";
            case 2 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E8 ? Math.floor(qty / 1000000.0) : qty / 1000000.0) + "M";
            case 3 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E11 ? Math.floor(qty / 1.0E9) : qty / 1.0E9) + "G";
            case 4 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E14 ? Math.floor(qty / 1.0E12) : qty / 1.0E12) + "T";
            case 5 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E17 ? Math.floor(qty / 1.0E15) : qty / 1.0E15) + "P";
            case 6 -> FORMATTER_WITH_UNITS.format(qty >= 1.0E20 ? Math.floor(qty / 1.0E18) : qty / 1.0E18) + "E";
            default -> "\u221e";
        };
    }

    public static String format(long qty) {
        return FORMATTER.format(qty);
    }

    static {
        FORMATTER_WITH_UNITS.setRoundingMode(RoundingMode.FLOOR);
    }
}

