/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric;

import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.AbstractClientModInitializer;
import com.refinedmods.refinedstorage.common.api.support.HelpTooltipComponent;
import com.refinedmods.refinedstorage.common.api.upgrade.AbstractUpgradeItem;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeMapping;
import com.refinedmods.refinedstorage.common.autocrafting.PatternItem;
import com.refinedmods.refinedstorage.common.autocrafting.PatternTooltipCache;
import com.refinedmods.refinedstorage.common.configurationcard.ConfigurationCardItemPropertyFunction;
import com.refinedmods.refinedstorage.common.content.BlockColorMap;
import com.refinedmods.refinedstorage.common.content.BlockEntities;
import com.refinedmods.refinedstorage.common.content.Blocks;
import com.refinedmods.refinedstorage.common.content.ContentNames;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.content.KeyMappings;
import com.refinedmods.refinedstorage.common.controller.ControllerItemPropertyFunction;
import com.refinedmods.refinedstorage.common.networking.CableBlock;
import com.refinedmods.refinedstorage.common.networking.NetworkCardItemPropertyFunction;
import com.refinedmods.refinedstorage.common.security.SecurityCardItemPropertyFunction;
import com.refinedmods.refinedstorage.common.storage.diskinterface.DiskInterfaceBlock;
import com.refinedmods.refinedstorage.common.storagemonitor.StorageMonitorBlockEntityRenderer;
import com.refinedmods.refinedstorage.common.support.network.item.NetworkItemPropertyFunction;
import com.refinedmods.refinedstorage.common.support.packet.PacketHandler;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterLockedUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterManagerActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocrafterNameUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskAddedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskRemovedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingMonitorTaskStatusChangedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewCancelResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewMaxAmountResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingPreviewResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingTaskCompletedPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.AutocraftingTreePreviewResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.EnergyInfoPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.ExportingIndicatorUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridActivePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridClearPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.GridUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.MessagePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.NetworkTransmitterStatusPacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.PatternGridAllowedAlternativesUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.ResourceSlotUpdatePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.StorageInfoResponsePacket;
import com.refinedmods.refinedstorage.common.support.packet.s2c.WirelessTransmitterDataPacket;
import com.refinedmods.refinedstorage.common.support.tooltip.CompositeClientTooltipComponent;
import com.refinedmods.refinedstorage.common.support.tooltip.HelpClientTooltipComponent;
import com.refinedmods.refinedstorage.common.upgrade.RegulatorUpgradeItem;
import com.refinedmods.refinedstorage.common.upgrade.UpgradeDestinationClientTooltipComponent;
import com.refinedmods.refinedstorage.common.util.IdentifierUtil;
import com.refinedmods.refinedstorage.fabric.autocrafting.PatternUnbakedModel;
import com.refinedmods.refinedstorage.fabric.mixin.ItemPropertiesAccessor;
import com.refinedmods.refinedstorage.fabric.networking.CableUnbakedModel;
import com.refinedmods.refinedstorage.fabric.storage.diskdrive.DiskDriveBlockEntityRendererImpl;
import com.refinedmods.refinedstorage.fabric.storage.diskdrive.DiskDriveUnbakedModel;
import com.refinedmods.refinedstorage.fabric.storage.diskinterface.DiskInterfaceBlockEntityRendererImpl;
import com.refinedmods.refinedstorage.fabric.storage.diskinterface.DiskInterfaceUnbakedModel;
import com.refinedmods.refinedstorage.fabric.storage.portablegrid.PortableGridBlockEntityRendererImpl;
import com.refinedmods.refinedstorage.fabric.storage.portablegrid.PortableGridUnbakedModel;
import com.refinedmods.refinedstorage.fabric.support.render.EmissiveModelRegistry;
import com.refinedmods.refinedstorage.fabric.support.render.QuadRotators;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Set;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.loading.v1.ModelLoadingPlugin;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.TooltipComponentCallback;
import net.minecraft.class_1703;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_5272;
import net.minecraft.class_5616;
import net.minecraft.class_5632;
import net.minecraft.class_6395;
import net.minecraft.class_8710;

public class ClientModInitializerImpl
extends AbstractClientModInitializer
implements ClientModInitializer {
    private static final String BLOCK_PREFIX = "block";
    private static final String ITEM_PREFIX = "item";

    public void onInitializeClient() {
        ClientModInitializerImpl.initializeClientPlatformApi();
        this.setRenderLayers();
        this.registerEmissiveModels();
        this.registerPacketHandlers();
        this.registerBlockEntityRenderers();
        this.registerCustomModels();
        this.registerCustomTooltips();
        ClientModInitializerImpl.registerScreens(new AbstractClientModInitializer.ScreenRegistration(this){

            @Override
            public <M extends class_1703, U extends class_437> void register(class_3917<? extends M> type, AbstractClientModInitializer.ScreenConstructor<M, U> factory) {
                class_3929.method_17542(type, factory::create);
            }
        });
        this.registerKeyMappings();
        this.registerModelPredicates();
        ClientModInitializerImpl.registerResourceRendering();
        ClientModInitializerImpl.registerAlternativeGridHints();
        this.registerItemProperties();
    }

    private void setRenderLayers() {
        this.setCutout(Blocks.INSTANCE.getImporter());
        this.setCutout(Blocks.INSTANCE.getExporter());
        this.setCutout(Blocks.INSTANCE.getExternalStorage());
        this.setCutout(Blocks.INSTANCE.getCable());
        this.setCutout(Blocks.INSTANCE.getGrid());
        this.setCutout(Blocks.INSTANCE.getCraftingGrid());
        this.setCutout(Blocks.INSTANCE.getPatternGrid());
        this.setCutout(Blocks.INSTANCE.getController());
        this.setCutout(Blocks.INSTANCE.getCreativeController());
        this.setCutout(Blocks.INSTANCE.getDetector());
        this.setCutout(Blocks.INSTANCE.getConstructor());
        this.setCutout(Blocks.INSTANCE.getDestructor());
        this.setCutout(Blocks.INSTANCE.getWirelessTransmitter());
        this.setCutout(Blocks.INSTANCE.getNetworkReceiver());
        this.setCutout(Blocks.INSTANCE.getNetworkTransmitter());
        this.setCutout(Blocks.INSTANCE.getPortableGrid());
        this.setCutout(Blocks.INSTANCE.getCreativePortableGrid());
        this.setCutout(Blocks.INSTANCE.getSecurityManager());
        this.setCutout(Blocks.INSTANCE.getRelay());
        this.setCutout(Blocks.INSTANCE.getDiskInterface());
        this.setCutout(Blocks.INSTANCE.getAutocrafter());
        this.setCutout(Blocks.INSTANCE.getAutocrafterManager());
        this.setCutout(Blocks.INSTANCE.getAutocraftingMonitor());
    }

    private void setCutout(BlockColorMap<?, ?> blockMap) {
        blockMap.values().forEach(x$0 -> this.setCutout((class_2248)x$0));
    }

    private void setCutout(class_2248 block) {
        BlockRenderLayerMap.INSTANCE.putBlock(block, class_1921.method_23581());
    }

    private void registerEmissiveModels() {
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getController(), "controller");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getCreativeController(), "controller");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getGrid(), "grid");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getCraftingGrid(), "crafting_grid");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getPatternGrid(), "pattern_grid");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getDetector(), "detector");
        this.registerConstructorDestructorEmissiveModels(Blocks.INSTANCE.getConstructor(), "constructor");
        this.registerConstructorDestructorEmissiveModels(Blocks.INSTANCE.getDestructor(), "destructor");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getWirelessTransmitter(), "wireless_transmitter");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getNetworkReceiver(), "network_receiver");
        Blocks.INSTANCE.getNetworkTransmitter().forEach((color, id, block) -> this.registerEmissiveNetworkTransmitterModels(color, id));
        Blocks.INSTANCE.getSecurityManager().forEach((color, id, block) -> this.registerEmissiveSecurityManagerModels(color, id));
        Blocks.INSTANCE.getRelay().forEach((color, id, block) -> this.registerEmissiveRelayModels(color, id));
        Blocks.INSTANCE.getAutocrafter().forEach((color, id, block) -> this.registerEmissiveAutocrafterModels(color, id));
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getAutocrafterManager(), "autocrafter_manager");
        this.registerColoredEmissiveModels(Blocks.INSTANCE.getAutocraftingMonitor(), "autocrafting_monitor");
    }

    private void registerColoredEmissiveModels(BlockColorMap<?, ?> blockMap, String blockDirectory) {
        blockMap.forEach((color, id, block) -> {
            class_2960 blockModelLocation = IdentifierUtil.createIdentifier("block/" + blockDirectory + "/" + color.method_7792());
            class_2960 spriteLocation = IdentifierUtil.createIdentifier("block/" + blockDirectory + "/cutouts/" + color.method_7792());
            EmissiveModelRegistry.INSTANCE.register(blockModelLocation, spriteLocation);
            EmissiveModelRegistry.INSTANCE.register(id.method_45136("item/" + id.method_12832()), spriteLocation);
        });
    }

    private void registerConstructorDestructorEmissiveModels(BlockColorMap<?, ?> blockMap, String blockDirectory) {
        blockMap.forEach((color, id, block) -> {
            class_2960 blockModelLocation = IdentifierUtil.createIdentifier("block/" + blockDirectory + "/active");
            class_2960 spriteLocation = IdentifierUtil.createIdentifier("block/" + blockDirectory + "/cutouts/active");
            EmissiveModelRegistry.INSTANCE.register(blockModelLocation, spriteLocation);
            EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("item/" + id.method_12832()), spriteLocation);
        });
    }

    private void registerEmissiveNetworkTransmitterModels(class_1767 color, class_2960 id) {
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("block/network_transmitter/" + color.method_7792()), IdentifierUtil.createIdentifier("block/network_transmitter/cutouts/" + color.method_7792()));
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("block/network_transmitter/error"), IdentifierUtil.createIdentifier("block/network_transmitter/cutouts/error"));
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("item/" + id.method_12832()), IdentifierUtil.createIdentifier("block/network_transmitter/cutouts/" + color.method_7792()));
    }

    private void registerEmissiveSecurityManagerModels(class_1767 color, class_2960 id) {
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("block/security_manager/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/back/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/front/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/left/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/right/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/top/" + color.method_7792()));
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("item/" + id.method_12832()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/back/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/front/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/left/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/right/" + color.method_7792()), IdentifierUtil.createIdentifier("block/security_manager/cutouts/top/" + color.method_7792()));
    }

    private void registerEmissiveRelayModels(class_1767 color, class_2960 id) {
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("block/relay/" + color.method_7792()), IdentifierUtil.createIdentifier("block/relay/cutouts/in/" + color.method_7792()), IdentifierUtil.createIdentifier("block/relay/cutouts/out/" + color.method_7792()));
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("item/" + id.method_12832()), IdentifierUtil.createIdentifier("block/relay/cutouts/in/" + color.method_7792()), IdentifierUtil.createIdentifier("block/relay/cutouts/out/" + color.method_7792()));
    }

    private void registerEmissiveAutocrafterModels(class_1767 color, class_2960 id) {
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("block/autocrafter/" + color.method_7792()), IdentifierUtil.createIdentifier("block/autocrafter/cutouts/side/" + color.method_7792()), IdentifierUtil.createIdentifier("block/autocrafter/cutouts/top/" + color.method_7792()));
        EmissiveModelRegistry.INSTANCE.register(IdentifierUtil.createIdentifier("item/" + id.method_12832()), IdentifierUtil.createIdentifier("block/autocrafter/cutouts/side/" + color.method_7792()), IdentifierUtil.createIdentifier("block/autocrafter/cutouts/top/" + color.method_7792()));
    }

    private void registerPacketHandlers() {
        ClientPlayNetworking.registerGlobalReceiver(StorageInfoResponsePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> StorageInfoResponsePacket.handle(packet)));
        ClientPlayNetworking.registerGlobalReceiver(GridUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(GridUpdatePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(GridClearPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> GridClearPacket.handle(ctx)));
        ClientPlayNetworking.registerGlobalReceiver(GridActivePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(GridActivePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocrafterManagerActivePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(AutocrafterManagerActivePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(EnergyInfoPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(EnergyInfoPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(WirelessTransmitterDataPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(WirelessTransmitterDataPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(ResourceSlotUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(ResourceSlotUpdatePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(NetworkTransmitterStatusPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(NetworkTransmitterStatusPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(MessagePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> MessagePacket.handle(packet)));
        ClientPlayNetworking.registerGlobalReceiver(PatternGridAllowedAlternativesUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(PatternGridAllowedAlternativesUpdatePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocrafterNameUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(AutocrafterNameUpdatePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocrafterLockedUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(AutocrafterLockedUpdatePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingPreviewResponsePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> AutocraftingPreviewResponsePacket.handle(packet)));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingTreePreviewResponsePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> AutocraftingTreePreviewResponsePacket.handle(packet)));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingPreviewCancelResponsePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> AutocraftingPreviewCancelResponsePacket.handle()));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingPreviewMaxAmountResponsePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> AutocraftingPreviewMaxAmountResponsePacket.handle(packet)));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingResponsePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> AutocraftingResponsePacket.handle(packet)));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingMonitorTaskAddedPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(AutocraftingMonitorTaskAddedPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingMonitorTaskRemovedPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(AutocraftingMonitorTaskRemovedPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingMonitorTaskStatusChangedPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(AutocraftingMonitorTaskStatusChangedPacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingMonitorActivePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(AutocraftingMonitorActivePacket::handle));
        ClientPlayNetworking.registerGlobalReceiver(AutocraftingTaskCompletedPacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler((packet, ctx) -> AutocraftingTaskCompletedPacket.handle(packet)));
        ClientPlayNetworking.registerGlobalReceiver(ExportingIndicatorUpdatePacket.PACKET_TYPE, ClientModInitializerImpl.wrapHandler(ExportingIndicatorUpdatePacket::handle));
    }

    private static <T extends class_8710> ClientPlayNetworking.PlayPayloadHandler<T> wrapHandler(PacketHandler<T> handler) {
        return (packet, ctx) -> handler.handle(packet, () -> ((ClientPlayNetworking.Context)ctx).player());
    }

    private void registerBlockEntityRenderers() {
        class_5616.method_32144(BlockEntities.INSTANCE.getDiskDrive(), ctx -> new DiskDriveBlockEntityRendererImpl());
        class_5616.method_32144(BlockEntities.INSTANCE.getStorageMonitor(), ctx -> new StorageMonitorBlockEntityRenderer());
        class_5616.method_32144(BlockEntities.INSTANCE.getPortableGrid(), ctx -> new PortableGridBlockEntityRendererImpl());
        class_5616.method_32144(BlockEntities.INSTANCE.getCreativePortableGrid(), ctx -> new PortableGridBlockEntityRendererImpl());
        class_5616.method_32144(BlockEntities.INSTANCE.getDiskInterface(), ctx -> new DiskInterfaceBlockEntityRendererImpl());
    }

    private void registerCustomModels() {
        ClientModInitializerImpl.registerDiskModels();
        QuadRotators quadRotators = new QuadRotators();
        ModelLoadingPlugin.register(pluginContext -> {
            this.registerCustomCableModels(pluginContext, quadRotators);
            this.registerCustomDiskDriveModels(pluginContext, quadRotators);
            this.registerCustomDiskInterfaceModels(pluginContext, quadRotators);
            this.registerCustomPortableGridModels(pluginContext, quadRotators);
            this.registerCustomPatternModel(pluginContext);
        });
    }

    private void registerCustomCableModels(ModelLoadingPlugin.Context pluginContext, QuadRotators quadRotators) {
        pluginContext.resolveModel().register(context -> {
            if (context.id().method_12836().equals("refinedstorage") && context.id().method_12832().startsWith("block/cable/") && !context.id().method_12832().startsWith("block/cable/core") && !context.id().method_12832().startsWith("block/cable/extension")) {
                class_1767 color = class_1767.method_7793((String)context.id().method_12832().replace("block/cable/", ""), (class_1767)((CableBlock)Blocks.INSTANCE.getCable().getDefault()).getColor());
                return new CableUnbakedModel(quadRotators, color);
            }
            return null;
        });
    }

    private void registerCustomDiskInterfaceModels(ModelLoadingPlugin.Context pluginContext, QuadRotators quadRotators) {
        pluginContext.resolveModel().register(context -> {
            if (context.id().method_12836().equals("refinedstorage") && context.id().method_12832().startsWith("item/") && context.id().method_12832().endsWith("disk_interface")) {
                boolean isDefault = !context.id().method_12832().endsWith("_disk_interface");
                class_1767 color = isDefault ? ((DiskInterfaceBlock)Blocks.INSTANCE.getDiskInterface().getDefault()).getColor() : class_1767.method_7793((String)context.id().method_12832().replace("_disk_interface", "").replace("item/", ""), (class_1767)((DiskInterfaceBlock)Blocks.INSTANCE.getDiskInterface().getDefault()).getColor());
                return new DiskInterfaceUnbakedModel(quadRotators, color);
            }
            if (context.id().method_12836().equals("refinedstorage") && context.id().method_12832().startsWith("block/disk_interface/") && !context.id().method_12832().startsWith("block/disk_interface/base_") && !context.id().method_12832().equals("block/disk_interface/inactive")) {
                class_1767 color = class_1767.method_7793((String)context.id().method_12832().replace("block/disk_interface/", ""), (class_1767)((DiskInterfaceBlock)Blocks.INSTANCE.getDiskInterface().getDefault()).getColor());
                return new DiskInterfaceUnbakedModel(quadRotators, color);
            }
            return null;
        });
    }

    private void registerCustomPortableGridModels(ModelLoadingPlugin.Context pluginContext, QuadRotators quadRotators) {
        class_2960 portableGridIdentifier = IdentifierUtil.createIdentifier("block/portable_grid");
        class_2960 portableGridIdentifierItem = IdentifierUtil.createIdentifier("item/portable_grid");
        class_2960 creativePortableGridIdentifier = IdentifierUtil.createIdentifier("block/creative_portable_grid");
        class_2960 creativePortableGridIdentifierItem = IdentifierUtil.createIdentifier("item/creative_portable_grid");
        pluginContext.resolveModel().register(context -> {
            if (context.id().equals((Object)portableGridIdentifier) || context.id().equals((Object)portableGridIdentifierItem) || context.id().equals((Object)creativePortableGridIdentifier) || context.id().equals((Object)creativePortableGridIdentifierItem)) {
                return new PortableGridUnbakedModel(quadRotators);
            }
            return null;
        });
    }

    private void registerCustomDiskDriveModels(ModelLoadingPlugin.Context pluginContext, QuadRotators quadRotators) {
        class_2960 diskDriveIdentifier = IdentifierUtil.createIdentifier("block/disk_drive");
        class_2960 diskDriveIdentifierItem = IdentifierUtil.createIdentifier("item/disk_drive");
        pluginContext.resolveModel().register(context -> {
            if (context.id().equals((Object)diskDriveIdentifier) || context.id().equals((Object)diskDriveIdentifierItem)) {
                return new DiskDriveUnbakedModel(quadRotators);
            }
            return null;
        });
    }

    private void registerCustomPatternModel(ModelLoadingPlugin.Context pluginContext) {
        class_2960 patternIdentifier = IdentifierUtil.createIdentifier("item/pattern");
        pluginContext.resolveModel().register(context -> {
            if (context.id().equals((Object)patternIdentifier)) {
                return new PatternUnbakedModel();
            }
            return null;
        });
    }

    private void registerCustomTooltips() {
        TooltipComponentCallback.EVENT.register(d -> {
            class_2561 patt2$temp;
            Set<UpgradeMapping> destinations;
            if (!(d instanceof AbstractUpgradeItem.UpgradeDestinationTooltipComponent)) return null;
            AbstractUpgradeItem.UpgradeDestinationTooltipComponent $b$0 = (AbstractUpgradeItem.UpgradeDestinationTooltipComponent)d;
            try {
                Set<UpgradeMapping> patt1$temp;
                destinations = patt1$temp = $b$0.destinations();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            class_2561 helpText = patt2$temp = $b$0.helpText();
            return new CompositeClientTooltipComponent(List.of(new UpgradeDestinationClientTooltipComponent(destinations), HelpClientTooltipComponent.create(helpText)));
        });
        TooltipComponentCallback.EVENT.register(data -> {
            class_2561 text;
            if (!(data instanceof HelpTooltipComponent)) return null;
            HelpTooltipComponent $b$0 = (HelpTooltipComponent)data;
            try {
                class_2561 patt1$temp;
                text = patt1$temp = $b$0.text();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            return HelpClientTooltipComponent.create(text);
        });
        TooltipComponentCallback.EVENT.register(d -> {
            ResourceAmount patt3$temp;
            class_2561 patt2$temp;
            Set<UpgradeMapping> destinations;
            if (!(d instanceof RegulatorUpgradeItem.RegulatorTooltipComponent)) return null;
            RegulatorUpgradeItem.RegulatorTooltipComponent $b$0 = (RegulatorUpgradeItem.RegulatorTooltipComponent)d;
            try {
                Set<UpgradeMapping> patt1$temp;
                destinations = patt1$temp = $b$0.destinations();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            class_2561 helpText = patt2$temp = $b$0.helpText();
            ResourceAmount r = patt3$temp = $b$0.configuredResource();
            return ClientModInitializerImpl.createRegulatorUpgradeClientTooltipComponent(destinations, r, helpText);
        });
        TooltipComponentCallback.EVENT.register(data -> {
            class_5632 selector0$temp = data;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PatternItem.CraftingPatternTooltipComponent.class, PatternItem.ProcessingPatternTooltipComponent.class, PatternItem.StonecutterPatternTooltipComponent.class, PatternItem.SmithingTablePatternTooltipComponent.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    PatternItem.CraftingPatternTooltipComponent component = (PatternItem.CraftingPatternTooltipComponent)selector0$temp;
                    yield PatternTooltipCache.getComponent(component);
                }
                case 1 -> {
                    PatternItem.ProcessingPatternTooltipComponent component = (PatternItem.ProcessingPatternTooltipComponent)selector0$temp;
                    yield PatternTooltipCache.getComponent(component);
                }
                case 2 -> {
                    PatternItem.StonecutterPatternTooltipComponent component = (PatternItem.StonecutterPatternTooltipComponent)selector0$temp;
                    yield PatternTooltipCache.getComponent(component);
                }
                case 3 -> {
                    PatternItem.SmithingTablePatternTooltipComponent component = (PatternItem.SmithingTablePatternTooltipComponent)selector0$temp;
                    yield PatternTooltipCache.getComponent(component);
                }
                default -> null;
            };
        });
    }

    private void registerKeyMappings() {
        KeyMappings.INSTANCE.setFocusSearchBar(KeyBindingHelper.registerKeyBinding((class_304)new class_304(ContentNames.FOCUS_SEARCH_BAR_TRANSLATION_KEY, class_3675.class_307.field_1668, 258, "mod.refinedstorage")));
        KeyMappings.INSTANCE.setOpenWirelessGrid(KeyBindingHelper.registerKeyBinding((class_304)new class_304(ContentNames.OPEN_WIRELESS_GRID_TRANSLATION_KEY, class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "mod.refinedstorage")));
        KeyMappings.INSTANCE.setOpenPortableGrid(KeyBindingHelper.registerKeyBinding((class_304)new class_304(ContentNames.OPEN_PORTABLE_GRID_TRANSLATION_KEY, class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "mod.refinedstorage")));
        KeyMappings.INSTANCE.setOpenWirelessAutocraftingMonitor(KeyBindingHelper.registerKeyBinding((class_304)new class_304(ContentNames.OPEN_WIRELESS_AUTOCRAFTING_MONITOR_TRANSLATION_KEY, class_3675.class_307.field_1668, class_3675.field_16237.method_1444(), "mod.refinedstorage")));
        ClientTickEvents.END_CLIENT_TICK.register(client -> ClientModInitializerImpl.handleInputEvents());
    }

    private void registerModelPredicates() {
        Items.INSTANCE.getControllers().forEach(controllerBlockItem -> ItemPropertiesAccessor.register((class_1792)controllerBlockItem.get(), IdentifierUtil.createIdentifier("stored_in_controller"), new ControllerItemPropertyFunction()));
    }

    private void registerItemProperties() {
        class_5272.method_27879((class_1792)Items.INSTANCE.getWirelessGrid(), (class_2960)NetworkItemPropertyFunction.NAME, (class_6395)new NetworkItemPropertyFunction());
        class_5272.method_27879((class_1792)Items.INSTANCE.getCreativeWirelessGrid(), (class_2960)NetworkItemPropertyFunction.NAME, (class_6395)new NetworkItemPropertyFunction());
        class_5272.method_27879((class_1792)Items.INSTANCE.getConfigurationCard(), (class_2960)ConfigurationCardItemPropertyFunction.NAME, (class_6395)new ConfigurationCardItemPropertyFunction());
        class_5272.method_27879((class_1792)Items.INSTANCE.getNetworkCard(), (class_2960)NetworkCardItemPropertyFunction.NAME, (class_6395)new NetworkCardItemPropertyFunction());
        class_5272.method_27879((class_1792)Items.INSTANCE.getSecurityCard(), (class_2960)SecurityCardItemPropertyFunction.NAME, (class_6395)new SecurityCardItemPropertyFunction());
        class_5272.method_27879((class_1792)Items.INSTANCE.getWirelessAutocraftingMonitor(), (class_2960)NetworkItemPropertyFunction.NAME, (class_6395)new NetworkItemPropertyFunction());
        class_5272.method_27879((class_1792)Items.INSTANCE.getCreativeWirelessAutocraftingMonitor(), (class_2960)NetworkItemPropertyFunction.NAME, (class_6395)new NetworkItemPropertyFunction());
    }
}

