/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric;

import com.mojang.authlib.GameProfile;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.AbstractPlatform;
import com.refinedmods.refinedstorage.common.Config;
import com.refinedmods.refinedstorage.common.api.support.network.NetworkNodeContainerProvider;
import com.refinedmods.refinedstorage.common.api.support.resource.FluidOperationResult;
import com.refinedmods.refinedstorage.common.support.containermenu.TransferManager;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.util.CustomBlockPlaceContext;
import com.refinedmods.refinedstorage.fabric.ConfigImpl;
import com.refinedmods.refinedstorage.fabric.api.RefinedStorageFabricApi;
import com.refinedmods.refinedstorage.fabric.grid.strategy.ItemGridInsertionStrategy;
import com.refinedmods.refinedstorage.fabric.mixin.EditBoxAccessor;
import com.refinedmods.refinedstorage.fabric.mixin.KeyMappingAccessor;
import com.refinedmods.refinedstorage.fabric.support.containermenu.ContainerTransferDestination;
import com.refinedmods.refinedstorage.fabric.support.containermenu.MenuOpenerImpl;
import com.refinedmods.refinedstorage.fabric.support.energy.EnergyStorageAdapter;
import com.refinedmods.refinedstorage.fabric.support.render.FluidVariantFluidRenderer;
import com.refinedmods.refinedstorage.fabric.support.resource.VariantUtil;
import com.refinedmods.refinedstorage.fabric.util.SimpleSingleStackStorage;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.impl.transfer.context.ConstantContainerItemContext;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_18;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_342;
import net.minecraft.class_3486;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3675;
import net.minecraft.class_3955;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_8001;
import net.minecraft.class_8566;
import net.minecraft.class_8710;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import team.reborn.energy.api.EnergyStorage;

public final class PlatformImpl
extends AbstractPlatform {
    private static final Logger LOGGER = LoggerFactory.getLogger(PlatformImpl.class);

    public PlatformImpl() {
        super(new MenuOpenerImpl(), new FluidVariantFluidRenderer(), ItemGridInsertionStrategy::new);
    }

    @Override
    public long getBucketAmount() {
        return 81000L;
    }

    @Override
    public Config getConfig() {
        return ConfigImpl.get();
    }

    @Override
    public boolean canEditBoxLoseFocus(class_342 editBox) {
        return ((EditBoxAccessor)editBox).getCanLoseFocus();
    }

    @Override
    public boolean isKeyDown(class_304 keyMapping) {
        return !keyMapping.method_1415() && class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)((KeyMappingAccessor)keyMapping).getKey().method_1444());
    }

    @Override
    public Optional<FluidOperationResult> drainContainer(class_1799 container) {
        if (container.method_7960()) {
            return Optional.empty();
        }
        SimpleSingleStackStorage interceptingStorage = new SimpleSingleStackStorage(container);
        Storage storage = (Storage)FluidStorage.ITEM.find(container, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)interceptingStorage));
        try (Transaction tx = Transaction.openOuter();){
            ResourceAmount extracted = StorageUtil.extractAny((Storage)storage, (long)Long.MAX_VALUE, (TransactionContext)tx);
            if (extracted == null) {
                Optional<FluidOperationResult> optional = Optional.empty();
                return optional;
            }
            Optional<FluidOperationResult> optional = Optional.of(new FluidOperationResult(interceptingStorage.getStack(), VariantUtil.ofFluidVariant((FluidVariant)extracted.resource()), extracted.amount()));
            return optional;
        }
    }

    @Override
    public Optional<FluidOperationResult> fillContainer(class_1799 container, com.refinedmods.refinedstorage.api.resource.ResourceAmount resourceAmount) {
        ResourceKey resourceKey = resourceAmount.resource();
        if (!(resourceKey instanceof FluidResource)) {
            return Optional.empty();
        }
        FluidResource fluidResource = (FluidResource)resourceKey;
        SimpleSingleStackStorage interceptingStorage = new SimpleSingleStackStorage(container);
        Storage storage = (Storage)FluidStorage.ITEM.find(container, (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)interceptingStorage));
        if (storage == null) {
            return Optional.empty();
        }
        try (Transaction tx = Transaction.openOuter();){
            long inserted = storage.insert((Object)VariantUtil.toFluidVariant(fluidResource), resourceAmount.amount(), (TransactionContext)tx);
            Optional<FluidOperationResult> optional = Optional.of(new FluidOperationResult(interceptingStorage.getStack(), fluidResource, inserted));
            return optional;
        }
    }

    @Override
    public TransferManager createTransferManager(class_1703 containerMenu) {
        return new TransferManager(containerMenu, ContainerTransferDestination::new);
    }

    @Override
    public long insertIntoContainer(class_1263 container, ItemResource itemResource, long amount, Action action) {
        try (Transaction tx = Transaction.openOuter();){
            long inserted = InventoryStorage.of((class_1263)container, null).insert((Object)VariantUtil.toItemVariant(itemResource), amount, (TransactionContext)tx);
            if (action == Action.EXECUTE) {
                tx.commit();
            }
            long l = inserted;
            return l;
        }
    }

    @Override
    public class_1799 getCloneItemStack(class_2680 state, class_1937 level, class_3965 hitResult, class_1657 player) {
        return state.method_26204().method_9574((class_4538)level, hitResult.method_17777(), state);
    }

    @Override
    public class_2371<class_1799> getRemainingCraftingItems(class_1657 player, class_3955 craftingRecipe, class_9694 input) {
        return craftingRecipe.method_8111((class_9695)input);
    }

    @Override
    public void onItemCrafted(class_1657 player, class_1799 craftedStack, class_8566 container) {
    }

    @Override
    public class_1657 getFakePlayer(class_3218 level, @Nullable UUID playerId) {
        return (class_1657)Optional.ofNullable(playerId).flatMap(id -> level.method_8503().method_3793().method_14512(id)).map(profile -> FakePlayer.get((class_3218)level, (GameProfile)profile)).orElseGet(() -> FakePlayer.get((class_3218)level));
    }

    @Override
    public boolean canBreakBlock(class_1937 level, class_2338 pos, class_2680 state, class_1657 player) {
        return ((PlayerBlockBreakEvents.Before)PlayerBlockBreakEvents.BEFORE.invoker()).beforeBlockBreak(level, player, pos, state, level.method_8321(pos));
    }

    @Override
    public boolean placeBlock(class_1937 level, class_2338 pos, class_2350 direction, class_1657 player, class_1799 stack) {
        CustomBlockPlaceContext ctx = new CustomBlockPlaceContext(level, player, class_1268.field_5808, stack, new class_3965(class_243.field_1353, direction, pos, false));
        class_1269 result = stack.method_7981((class_1838)ctx);
        return result.method_23665();
    }

    @Override
    public boolean placeFluid(class_1937 level, class_2338 pos, class_2350 direction, class_1657 player, FluidResource fluidResource) {
        class_2402 lbc;
        boolean canPlace;
        class_3611 content = fluidResource.fluid();
        if (!(content instanceof class_3609)) {
            return false;
        }
        class_2680 blockState = level.method_8320(pos);
        class_2248 block = blockState.method_26204();
        boolean replaceable = blockState.method_26188(content);
        boolean bl = canPlace = blockState.method_26215() || replaceable || block instanceof class_2402 && (lbc = (class_2402)block).method_10310(player, (class_1922)level, pos, blockState, content);
        if (!canPlace || blockState.method_26227().method_15771()) {
            return false;
        }
        if (block instanceof class_2402) {
            lbc = (class_2402)block;
            if (content == class_3612.field_15910) {
                lbc.method_10311((class_1936)level, pos, blockState, ((class_3609)content).method_15729(false));
                this.playEmptySound(content, player, (class_1936)level, pos);
                return true;
            }
        }
        return this.doPlaceFluid(level, pos, player, content, blockState, replaceable);
    }

    private boolean doPlaceFluid(class_1937 level, class_2338 pos, class_1657 player, class_3611 content, class_2680 blockState, boolean replaceable) {
        if (replaceable && !blockState.method_51176()) {
            level.method_22352(pos, true);
        }
        if (!level.method_8652(pos, content.method_15785().method_15759(), 11) && !blockState.method_26227().method_15771()) {
            return false;
        }
        this.playEmptySound(content, player, (class_1936)level, pos);
        return true;
    }

    private void playEmptySound(class_3611 content, class_1657 player, class_1936 level, class_2338 pos) {
        class_3414 soundEvent = content.method_15791(class_3486.field_15518) ? class_3417.field_15010 : class_3417.field_14834;
        level.method_8396(player, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28166, pos);
    }

    @Override
    public class_1799 getBlockAsItemStack(class_2248 block, class_2680 state, class_2350 direction, class_4538 level, class_2338 position, class_1657 player) {
        return block.method_9574(level, position, state);
    }

    @Override
    public Optional<class_3414> getBucketPickupSound(class_2404 liquidBlock, class_2680 state) {
        return liquidBlock.method_32351();
    }

    @Override
    public List<class_5684> processTooltipComponents(class_1799 stack, class_332 graphics, int mouseX, Optional<class_5632> imageComponent, List<class_2561> components) {
        List<class_5684> processedComponents = components.stream().map(class_2561::method_30937).map(class_5684::method_32662).collect(Collectors.toList());
        imageComponent.ifPresent(image -> processedComponents.add(1, class_5684.method_32663((class_5632)image)));
        return processedComponents;
    }

    @Override
    public void renderTooltip(class_332 graphics, List<class_5684> components, int x, int y) {
        graphics.method_51435(class_310.method_1551().field_1772, components, x, y, class_8001.field_41687);
    }

    @Override
    public Optional<com.refinedmods.refinedstorage.api.network.energy.EnergyStorage> getEnergyStorage(class_1799 stack) {
        ConstantContainerItemContext ctx = new ConstantContainerItemContext(ItemVariant.of((class_1799)stack), (long)stack.method_7947());
        return Optional.ofNullable((EnergyStorage)EnergyStorage.ITEM.find(stack, (Object)ctx)).filter(EnergyStorageAdapter.class::isInstance).map(EnergyStorageAdapter.class::cast).map(EnergyStorageAdapter::getEnergyStorage);
    }

    @Override
    public <T extends class_8710> void sendPacketToServer(T packet) {
        ClientPlayNetworking.send(packet);
    }

    @Override
    public <T extends class_8710> void sendPacketToClient(class_3222 player, T packet) {
        ServerPlayNetworking.send((class_3222)player, packet);
    }

    @Override
    public void saveSavedData(class_18 savedData, File file, class_7225.class_7874 provider, BiConsumer<File, class_7225.class_7874> defaultSaveFunction) {
        if (!savedData.method_79()) {
            return;
        }
        Path targetPath = file.toPath().toAbsolutePath();
        Path tempFile = targetPath.getParent().resolve(file.getName() + ".temp");
        class_2487 compoundTag = new class_2487();
        compoundTag.method_10566("data", (class_2520)savedData.method_75(new class_2487(), provider));
        class_2512.method_48310((class_2487)compoundTag);
        try {
            this.doSave(compoundTag, tempFile, targetPath);
        }
        catch (IOException e) {
            LOGGER.error("Could not save data", (Throwable)e);
        }
        savedData.method_78(false);
    }

    @Override
    @Nullable
    public NetworkNodeContainerProvider getContainerProvider(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        return (NetworkNodeContainerProvider)RefinedStorageFabricApi.INSTANCE.getNetworkNodeContainerProviderLookup().find(level, pos, (Object)direction);
    }

    @Override
    @Nullable
    public NetworkNodeContainerProvider getContainerProviderSafely(class_1937 level, class_2338 pos, @Nullable class_2350 direction) {
        if (!level.method_8477(pos)) {
            return null;
        }
        class_2586 safeBlockEntity = level.method_8500(pos).method_12201(pos, class_2818.class_2819.field_12859);
        if (safeBlockEntity == null) {
            return null;
        }
        return (NetworkNodeContainerProvider)RefinedStorageFabricApi.INSTANCE.getNetworkNodeContainerProviderLookup().find(level, pos, level.method_8320(pos), safeBlockEntity, (Object)direction);
    }

    @Override
    public void setSlotY(class_1735 slot, int y) {
        slot.field_7872 = y;
    }

    @Override
    public void requestModelDataUpdateOnClient(class_1936 level, class_2338 pos, boolean updateChunk) {
        if (!level.method_8608()) {
            throw new IllegalArgumentException("Cannot request model data update on server");
        }
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        if (updateChunk && level instanceof class_1937) {
            class_1937 updatable = (class_1937)level;
            updatable.method_8413(blockEntity.method_11016(), blockEntity.method_11010(), blockEntity.method_11010(), 3);
        }
    }

    private void doSave(class_2487 compoundTag, Path tempFile, Path targetPath) throws IOException {
        class_2507.method_30614((class_2487)compoundTag, (Path)tempFile);
        try {
            Files.move(tempFile, targetPath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException ignored) {
            Files.move(tempFile, targetPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

