/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.fabric.api.FabricStorageExternalPatternSinkStrategy;
import java.util.Collection;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

class FabricStorageExternalPatternSinkStrategyImpl<T>
implements FabricStorageExternalPatternSinkStrategy {
    private final BlockApiCache<Storage<T>, class_2350> cache;
    private final Function<ResourceKey, @NullableType T> toPlatformMapper;
    private final class_2350 direction;

    FabricStorageExternalPatternSinkStrategyImpl(BlockApiLookup<Storage<T>, class_2350> lookup, Function<ResourceKey, @NullableType T> toPlatformMapper, class_3218 serverLevel, class_2338 pos, class_2350 direction) {
        this.cache = BlockApiCache.create(lookup, (class_3218)serverLevel, (class_2338)pos);
        this.toPlatformMapper = toPlatformMapper;
        this.direction = direction;
    }

    @Override
    public ExternalPatternSink.Result accept(Transaction tx, Collection<ResourceAmount> resources) {
        boolean anyResourceWasApplicable = false;
        for (ResourceAmount resourceAmount : resources) {
            T platformResource = this.toPlatformMapper.apply(resourceAmount.resource());
            if (platformResource == null) continue;
            anyResourceWasApplicable = true;
            Storage storage = (Storage)this.cache.find((Object)this.direction);
            if (storage == null) {
                return ExternalPatternSink.Result.SKIPPED;
            }
            if (storage.insert(platformResource, resourceAmount.amount(), (TransactionContext)tx) == resourceAmount.amount()) continue;
            return ExternalPatternSink.Result.REJECTED;
        }
        return anyResourceWasApplicable ? ExternalPatternSink.Result.ACCEPTED : ExternalPatternSink.Result.SKIPPED;
    }

    @Override
    public boolean isEmpty() {
        Storage storage = (Storage)this.cache.find((Object)this.direction);
        if (storage == null) {
            return true;
        }
        return StorageUtil.findStoredResource((Storage)storage) == null;
    }
}

