/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.autocrafting;

import com.refinedmods.refinedstorage.api.autocrafting.task.ExternalPatternSink;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.resource.ResourceAmount;
import com.refinedmods.refinedstorage.common.api.autocrafting.PlatformPatternProviderExternalPatternSink;
import com.refinedmods.refinedstorage.fabric.api.FabricStorageExternalPatternSinkStrategy;
import java.util.Collection;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;

class FabricStoragePatternProviderExternalPatternSink
implements PlatformPatternProviderExternalPatternSink {
    private final Set<FabricStorageExternalPatternSinkStrategy> strategies;

    FabricStoragePatternProviderExternalPatternSink(Set<FabricStorageExternalPatternSinkStrategy> strategies) {
        this.strategies = strategies;
    }

    @Override
    public ExternalPatternSink.Result accept(Collection<ResourceAmount> resources, Action action) {
        ExternalPatternSink.Result result = ExternalPatternSink.Result.SKIPPED;
        try (Transaction tx = Transaction.openOuter();){
            for (FabricStorageExternalPatternSinkStrategy strategy : this.strategies) {
                ExternalPatternSink.Result strategyResult = strategy.accept(tx, resources);
                if (strategyResult == ExternalPatternSink.Result.REJECTED) {
                    ExternalPatternSink.Result result2 = strategyResult;
                    return result2;
                }
                result = this.and(result, strategyResult);
            }
            if (action == Action.EXECUTE) {
                tx.commit();
            }
        }
        return result;
    }

    private ExternalPatternSink.Result and(ExternalPatternSink.Result a, ExternalPatternSink.Result b) {
        if (a == ExternalPatternSink.Result.SKIPPED) {
            return b;
        }
        if (a == ExternalPatternSink.Result.REJECTED || b == ExternalPatternSink.Result.REJECTED) {
            return ExternalPatternSink.Result.REJECTED;
        }
        return ExternalPatternSink.Result.ACCEPTED;
    }

    @Override
    public boolean isEmpty() {
        for (FabricStorageExternalPatternSinkStrategy strategy : this.strategies) {
            if (strategy.isEmpty()) continue;
            return false;
        }
        return true;
    }
}

