/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.exporter;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.network.impl.node.exporter.ExporterTransferStrategyImpl;
import com.refinedmods.refinedstorage.api.network.impl.node.exporter.MissingResourcesListeningExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.network.node.exporter.ExporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.exporter.ExporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.storage.root.FuzzyRootStorage;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.content.Items;
import com.refinedmods.refinedstorage.common.exporter.ExporterTransferQuotaProvider;
import com.refinedmods.refinedstorage.fabric.storage.FabricStorageInsertableStorage;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class FabricStorageExporterTransferStrategyFactory<T>
implements ExporterTransferStrategyFactory {
    private final Class<? extends ResourceKey> resourceType;
    private final BlockApiLookup<Storage<T>, class_2350> lookup;
    private final Function<ResourceKey, @NullableType T> toPlatformMapper;
    private final long singleAmount;

    public FabricStorageExporterTransferStrategyFactory(Class<? extends ResourceKey> resourceType, BlockApiLookup<Storage<T>, class_2350> lookup, Function<ResourceKey, @NullableType T> toPlatformMapper, long singleAmount) {
        this.resourceType = resourceType;
        this.lookup = lookup;
        this.toPlatformMapper = toPlatformMapper;
        this.singleAmount = singleAmount;
    }

    @Override
    public Class<? extends ResourceKey> getResourceType() {
        return this.resourceType;
    }

    @Override
    public ExporterTransferStrategy create(class_3218 level, class_2338 pos, class_2350 direction, UpgradeState upgradeState, boolean fuzzyMode) {
        FabricStorageInsertableStorage<T> destination = new FabricStorageInsertableStorage<T>(this.lookup, this.toPlatformMapper, level, pos, direction);
        ExporterTransferStrategy strategy = this.create(fuzzyMode, destination, new ExporterTransferQuotaProvider(this.singleAmount, upgradeState, destination::getAmount, true));
        if (upgradeState.has(Items.INSTANCE.getAutocraftingUpgrade())) {
            return new MissingResourcesListeningExporterTransferStrategy(strategy, MissingResourcesListeningExporterTransferStrategy.OnMissingResources.scheduleAutocrafting(new ExporterTransferQuotaProvider(this.singleAmount, upgradeState, destination::getAmount, false)));
        }
        return strategy;
    }

    private ExporterTransferStrategy create(boolean fuzzyMode, FabricStorageInsertableStorage<T> destination, ToLongFunction<ResourceKey> transferQuotaProvider) {
        if (fuzzyMode) {
            return new ExporterTransferStrategyImpl(destination, transferQuotaProvider, FuzzyRootStorage.expander());
        }
        return new ExporterTransferStrategyImpl(destination, transferQuotaProvider);
    }
}

