/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.grid.strategy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.Storage;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.fabric.support.resource.VariantUtil;
import com.refinedmods.refinedstorage.fabric.util.SimpleSingleStackStorage;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_3222;

public class FluidGridExtractionStrategy
implements GridExtractionStrategy {
    private static final ItemVariant BUCKET_ITEM_VARIANT = ItemVariant.of((class_1935)class_1802.field_8550);
    private static final ItemResource BUCKET_ITEM_RESOURCE = new ItemResource(class_1802.field_8550);
    private final GridOperations gridOperations;
    private final PlayerInventoryStorage playerInventoryStorage;
    private final net.fabricmc.fabric.api.transfer.v1.storage.Storage<ItemVariant> playerCursorStorage;
    private final Storage itemStorage;

    public FluidGridExtractionStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        this.gridOperations = grid.createOperations(ResourceTypes.FLUID, player);
        this.playerInventoryStorage = PlayerInventoryStorage.of((class_1661)player.method_31548());
        this.playerCursorStorage = PlayerInventoryStorage.getCursorStorage((class_1703)containerMenu);
        this.itemStorage = grid.getItemStorage();
    }

    @Override
    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (resource instanceof FluidResource) {
            FluidResource fluidResource = (FluidResource)resource;
            boolean containerOnCursor = this.isFluidContainerOnCursor();
            boolean bucketInInventory = this.hasBucketInInventory();
            boolean bucketInStorage = this.hasBucketInStorage();
            if (containerOnCursor) {
                this.extractWithContainerOnCursor(fluidResource, extractMode);
            } else if (bucketInInventory) {
                this.extractWithBucketInInventory(fluidResource, extractMode, cursor);
            } else if (bucketInStorage) {
                this.extractWithBucketInStorage(fluidResource, extractMode, cursor);
            }
            return true;
        }
        return false;
    }

    private void extractWithContainerOnCursor(FluidResource fluidResource, GridExtractMode mode) {
        try (Transaction tx = Transaction.openOuter();){
            class_1799 stack = this.extractContainerFromCursor(tx);
            SimpleSingleStackStorage interceptingStorage = SimpleSingleStackStorage.forStack(stack);
            net.fabricmc.fabric.api.transfer.v1.storage.Storage dest = (net.fabricmc.fabric.api.transfer.v1.storage.Storage)FluidStorage.ITEM.find(interceptingStorage.getStack(), (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)interceptingStorage));
            if (dest == null) {
                return;
            }
            this.gridOperations.extract(fluidResource, mode, (resource2, amount, action, source) -> {
                if (!(resource2 instanceof FluidResource)) {
                    return 0L;
                }
                FluidResource fluidResource2 = (FluidResource)resource2;
                try (Transaction innerTx = tx.openNested();){
                    long inserted = dest.insert((Object)VariantUtil.toFluidVariant(fluidResource2), amount, (TransactionContext)innerTx);
                    boolean couldInsertContainer = this.insertResultingContainerIntoInventory(interceptingStorage, true, innerTx);
                    if (!couldInsertContainer) {
                        long l = 0L;
                        return l;
                    }
                    if (action == Action.EXECUTE) {
                        innerTx.commit();
                        tx.commit();
                    }
                    long l = inserted;
                    return l;
                }
            });
        }
    }

    private class_1799 extractContainerFromCursor(Transaction tx) {
        StorageView view = (StorageView)this.playerCursorStorage.iterator().next();
        ItemVariant variant = (ItemVariant)view.getResource();
        class_1799 stack = variant.toStack((int)view.getAmount());
        this.playerCursorStorage.extract((Object)variant, 1L, (TransactionContext)tx);
        return stack;
    }

    private void extractWithBucketInStorage(FluidResource fluidResource, GridExtractMode mode, boolean cursor) {
        SimpleSingleStackStorage interceptingStorage = SimpleSingleStackStorage.forEmptyBucket();
        net.fabricmc.fabric.api.transfer.v1.storage.Storage destination = (net.fabricmc.fabric.api.transfer.v1.storage.Storage)FluidStorage.ITEM.find(interceptingStorage.getStack(), (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)interceptingStorage));
        if (destination == null) {
            return;
        }
        this.gridOperations.extract(fluidResource, mode, (resource, amount, action, source) -> {
            if (!(resource instanceof FluidResource)) {
                return 0L;
            }
            FluidResource fluidResource2 = (FluidResource)resource;
            try (Transaction tx = Transaction.openOuter();){
                long inserted = destination.insert((Object)VariantUtil.toFluidVariant(fluidResource2), amount, (TransactionContext)tx);
                boolean couldInsertBucket = this.insertResultingContainerIntoInventory(interceptingStorage, cursor, tx);
                if (!couldInsertBucket) {
                    long l = 0L;
                    return l;
                }
                if (action == Action.EXECUTE) {
                    this.itemStorage.extract(BUCKET_ITEM_RESOURCE, 1L, Action.EXECUTE, source);
                    tx.commit();
                }
                long l = inserted;
                return l;
            }
        });
    }

    private void extractWithBucketInInventory(FluidResource fluidResource, GridExtractMode mode, boolean cursor) {
        try (Transaction tx = Transaction.openOuter();){
            this.playerInventoryStorage.extract((Object)BUCKET_ITEM_VARIANT, 1L, (TransactionContext)tx);
            SimpleSingleStackStorage interceptingStorage = SimpleSingleStackStorage.forEmptyBucket();
            net.fabricmc.fabric.api.transfer.v1.storage.Storage dest = (net.fabricmc.fabric.api.transfer.v1.storage.Storage)FluidStorage.ITEM.find(interceptingStorage.getStack(), (Object)ContainerItemContext.ofSingleSlot((SingleSlotStorage)interceptingStorage));
            if (dest == null) {
                return;
            }
            this.gridOperations.extract(fluidResource, mode, (resource, amount, action, source) -> {
                if (!(resource instanceof FluidResource)) {
                    return 0L;
                }
                FluidResource fluidResource2 = (FluidResource)resource;
                try (Transaction innerTx = tx.openNested();){
                    long inserted = dest.insert((Object)VariantUtil.toFluidVariant(fluidResource2), amount, (TransactionContext)innerTx);
                    boolean couldInsertBucket = this.insertResultingContainerIntoInventory(interceptingStorage, cursor, innerTx);
                    if (!couldInsertBucket) {
                        long l = 0L;
                        return l;
                    }
                    if (action == Action.EXECUTE) {
                        innerTx.commit();
                        tx.commit();
                    }
                    long l = inserted;
                    return l;
                }
            });
        }
    }

    private boolean insertResultingContainerIntoInventory(SimpleSingleStackStorage interceptingStorage, boolean cursor, Transaction innerTx) {
        PlayerInventoryStorage relevantStorage = cursor ? this.playerCursorStorage : this.playerInventoryStorage;
        ItemVariant itemVariant = ItemVariant.of((class_1799)interceptingStorage.getStack());
        return relevantStorage.insert((Object)itemVariant, 1L, (TransactionContext)innerTx) != 0L;
    }

    private boolean isFluidContainerOnCursor() {
        ContainerItemContext ctx;
        StorageView view = (StorageView)this.playerCursorStorage.iterator().next();
        ItemVariant variant = (ItemVariant)view.getResource();
        class_1799 stack = variant.toStack((int)view.getAmount());
        return FluidStorage.ITEM.find(stack, (Object)(ctx = ContainerItemContext.withConstant((class_1799)stack))) != null;
    }

    private boolean hasBucketInInventory() {
        try (Transaction tx = Transaction.openOuter();){
            boolean bl = this.playerInventoryStorage.extract((Object)BUCKET_ITEM_VARIANT, 1L, (TransactionContext)tx) == 1L;
            return bl;
        }
    }

    private boolean hasBucketInStorage() {
        return this.itemStorage.extract(BUCKET_ITEM_RESOURCE, 1L, Action.SIMULATE, Actor.EMPTY) == 1L;
    }
}

