/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.grid.strategy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.FluidResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.fabric.support.resource.VariantUtil;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_3222;

public class FluidGridInsertionStrategy
implements GridInsertionStrategy {
    private final class_1703 containerMenu;
    private final GridOperations gridOperations;
    private final class_1657 player;
    private final PlayerInventoryStorage playerInventoryStorage;

    public FluidGridInsertionStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        this.containerMenu = containerMenu;
        this.gridOperations = grid.createOperations(ResourceTypes.FLUID, player);
        this.player = player;
        this.playerInventoryStorage = PlayerInventoryStorage.of((class_1661)player.method_31548());
    }

    @Override
    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        Storage<FluidVariant> cursorStorage = this.getFluidCursorStorage();
        if (cursorStorage == null) {
            return false;
        }
        FluidVariant extractableResource = (FluidVariant)StorageUtil.findExtractableResource(cursorStorage, null);
        if (extractableResource == null) {
            return false;
        }
        FluidResource fluidResource = VariantUtil.ofFluidVariant(extractableResource);
        this.gridOperations.insert(fluidResource, insertMode, (resource, amount, action, source) -> {
            if (!(resource instanceof FluidResource)) {
                return 0L;
            }
            FluidResource fluidResource2 = (FluidResource)resource;
            FluidVariant fluidVariant = VariantUtil.toFluidVariant(fluidResource2);
            try (Transaction tx = Transaction.openOuter();){
                long extracted = cursorStorage.extract((Object)fluidVariant, amount, (TransactionContext)tx);
                if (action == Action.EXECUTE) {
                    tx.commit();
                }
                long l = extracted;
                return l;
            }
        });
        return true;
    }

    @Nullable
    private Storage<FluidVariant> getFluidCursorStorage() {
        return (Storage)FluidStorage.ITEM.find(this.containerMenu.method_34255(), (Object)ContainerItemContext.ofPlayerCursor((class_1657)this.player, (class_1703)this.containerMenu));
    }

    @Override
    public boolean onTransfer(int slotIndex) {
        SingleSlotStorage itemSlotStorage = this.playerInventoryStorage.getSlot(slotIndex);
        if (itemSlotStorage == null) {
            return false;
        }
        Storage fluidSlotStorage = (Storage)FluidStorage.ITEM.find(((ItemVariant)itemSlotStorage.getResource()).toStack(), (Object)ContainerItemContext.ofPlayerSlot((class_1657)this.player, (SingleSlotStorage)itemSlotStorage));
        if (fluidSlotStorage == null) {
            return false;
        }
        FluidVariant extractableResource = (FluidVariant)StorageUtil.findExtractableResource((Storage)fluidSlotStorage, null);
        if (extractableResource == null) {
            return false;
        }
        FluidResource fluidResource = VariantUtil.ofFluidVariant(extractableResource);
        this.gridOperations.insert(fluidResource, GridInsertMode.ENTIRE_RESOURCE, (resource, amount, action, source) -> {
            if (!(resource instanceof FluidResource)) {
                return 0L;
            }
            FluidResource fluidResource2 = (FluidResource)resource;
            FluidVariant fluidVariant = VariantUtil.toFluidVariant(fluidResource2);
            try (Transaction tx = Transaction.openOuter();){
                long extracted = fluidSlotStorage.extract((Object)fluidVariant, amount, (TransactionContext)tx);
                if (action == Action.EXECUTE) {
                    tx.commit();
                }
                long l = extracted;
                return l;
            }
        });
        return true;
    }
}

