/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.grid.strategy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridExtractionStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.fabric.support.resource.VariantUtil;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_3222;

public class ItemGridExtractionStrategy
implements GridExtractionStrategy {
    private final GridOperations gridOperations;
    private final PlayerInventoryStorage playerInventoryStorage;
    private final SingleSlotStorage<ItemVariant> playerCursorStorage;

    public ItemGridExtractionStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        this.gridOperations = grid.createOperations(ResourceTypes.ITEM, player);
        this.playerInventoryStorage = PlayerInventoryStorage.of((class_1661)player.method_31548());
        this.playerCursorStorage = PlayerInventoryStorage.getCursorStorage((class_1703)containerMenu);
    }

    @Override
    public boolean onExtract(PlatformResourceKey resource, GridExtractMode extractMode, boolean cursor) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            this.gridOperations.extract(itemResource, extractMode, (r, amount, action, source) -> {
                if (!(r instanceof ItemResource)) {
                    return 0L;
                }
                ItemResource itemResource2 = (ItemResource)r;
                ItemVariant itemVariant = VariantUtil.toItemVariant(itemResource2);
                try (Transaction tx = Transaction.openOuter();){
                    long inserted = this.insert(itemVariant, amount, tx, cursor);
                    if (action == Action.EXECUTE) {
                        tx.commit();
                    }
                    long l = inserted;
                    return l;
                }
            });
            return true;
        }
        return false;
    }

    private long insert(ItemVariant itemVariant, long amount, Transaction tx, boolean cursor) {
        PlayerInventoryStorage relevantStorage = cursor ? this.playerCursorStorage : this.playerInventoryStorage;
        return relevantStorage.insert((Object)itemVariant, amount, (TransactionContext)tx);
    }
}

