/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.grid.strategy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridInsertionStrategy;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.fabric.support.resource.VariantUtil;
import net.fabricmc.fabric.api.transfer.v1.item.InventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class ItemGridInsertionStrategy
implements GridInsertionStrategy {
    private final class_1703 containerMenu;
    private final GridOperations gridOperations;
    private final SingleSlotStorage<ItemVariant> playerCursorStorage;

    public ItemGridInsertionStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        this.containerMenu = containerMenu;
        this.gridOperations = grid.createOperations(ResourceTypes.ITEM, player);
        this.playerCursorStorage = PlayerInventoryStorage.getCursorStorage((class_1703)containerMenu);
    }

    @Override
    public boolean onInsert(GridInsertMode insertMode, boolean tryAlternatives) {
        class_1799 carried = this.containerMenu.method_34255();
        if (carried.method_7960()) {
            return false;
        }
        ItemResource itemResource = ItemResource.ofItemStack(carried);
        this.gridOperations.insert(itemResource, insertMode, (resource, amount, action, source) -> {
            if (!(resource instanceof ItemResource)) {
                return 0L;
            }
            ItemResource itemResource2 = (ItemResource)resource;
            try (Transaction tx = Transaction.openOuter();){
                ItemVariant itemVariant = VariantUtil.toItemVariant(itemResource2);
                long extracted = this.playerCursorStorage.extract((Object)itemVariant, amount, (TransactionContext)tx);
                if (action == Action.EXECUTE) {
                    tx.commit();
                }
                long l = extracted;
                return l;
            }
        });
        return true;
    }

    @Override
    public boolean onTransfer(int slotIndex) {
        class_1735 slot = this.containerMenu.method_7611(slotIndex);
        InventoryStorage inventoryStorage = InventoryStorage.of((class_1263)slot.field_7871, null);
        SingleSlotStorage storage = inventoryStorage.getSlot(slot.method_34266());
        ItemVariant itemVariantInSlot = (ItemVariant)StorageUtil.findExtractableResource((Storage)storage, null);
        if (itemVariantInSlot == null) {
            return false;
        }
        ItemResource itemResource = VariantUtil.ofItemVariant(itemVariantInSlot);
        this.gridOperations.insert(itemResource, GridInsertMode.ENTIRE_RESOURCE, (resource, amount, action, source) -> {
            if (!(resource instanceof ItemResource)) {
                return 0L;
            }
            ItemResource itemResource2 = (ItemResource)resource;
            try (Transaction tx = Transaction.openOuter();){
                ItemVariant itemVariant = VariantUtil.toItemVariant(itemResource2);
                long extracted = storage.extract((Object)itemVariant, amount, (TransactionContext)tx);
                if (action == Action.EXECUTE) {
                    tx.commit();
                }
                long l = extracted;
                return l;
            }
        });
        return true;
    }
}

