/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.grid.strategy;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.network.node.grid.GridExtractMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridInsertMode;
import com.refinedmods.refinedstorage.api.network.node.grid.GridOperations;
import com.refinedmods.refinedstorage.common.api.grid.Grid;
import com.refinedmods.refinedstorage.common.api.grid.GridScrollMode;
import com.refinedmods.refinedstorage.common.api.grid.strategy.GridScrollingStrategy;
import com.refinedmods.refinedstorage.common.api.support.resource.PlatformResourceKey;
import com.refinedmods.refinedstorage.common.support.resource.ItemResource;
import com.refinedmods.refinedstorage.common.support.resource.ResourceTypes;
import com.refinedmods.refinedstorage.fabric.support.resource.VariantUtil;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_3222;

public class ItemGridScrollingStrategy
implements GridScrollingStrategy {
    private final GridOperations gridOperations;
    private final PlayerInventoryStorage playerInventoryStorage;
    private final SingleSlotStorage<ItemVariant> playerCursorStorage;

    public ItemGridScrollingStrategy(class_1703 containerMenu, class_3222 player, Grid grid) {
        this.gridOperations = grid.createOperations(ResourceTypes.ITEM, player);
        this.playerInventoryStorage = PlayerInventoryStorage.of((class_1661)player.method_31548());
        this.playerCursorStorage = PlayerInventoryStorage.getCursorStorage((class_1703)containerMenu);
    }

    @Override
    public boolean onScroll(PlatformResourceKey resource, GridScrollMode scrollMode, int slotIndex) {
        if (resource instanceof ItemResource) {
            ItemResource itemResource = (ItemResource)resource;
            PlayerInventoryStorage playerStorage = slotIndex >= 0 ? this.playerInventoryStorage.getSlot(slotIndex) : this.playerInventoryStorage;
            switch (scrollMode) {
                case GRID_TO_INVENTORY: {
                    this.handleGridToInventoryScroll(itemResource, (Storage<ItemVariant>)playerStorage);
                    break;
                }
                case INVENTORY_TO_GRID: {
                    this.handleInventoryToGridScroll(itemResource, (Storage<ItemVariant>)playerStorage);
                    break;
                }
                case GRID_TO_CURSOR: {
                    this.handleGridToInventoryScroll(itemResource, (Storage<ItemVariant>)this.playerCursorStorage);
                }
            }
            return true;
        }
        return false;
    }

    private void handleInventoryToGridScroll(ItemResource itemResource, Storage<ItemVariant> sourceStorage) {
        this.gridOperations.insert(itemResource, GridInsertMode.SINGLE_RESOURCE, (resource, amount, action, source) -> {
            if (!(resource instanceof ItemResource)) {
                return 0L;
            }
            ItemResource itemResource2 = (ItemResource)resource;
            try (Transaction tx = Transaction.openOuter();){
                ItemVariant itemVariant = VariantUtil.toItemVariant(itemResource2);
                long extracted = sourceStorage.extract((Object)itemVariant, amount, (TransactionContext)tx);
                if (action == Action.EXECUTE) {
                    tx.commit();
                }
                long l = extracted;
                return l;
            }
        });
    }

    private void handleGridToInventoryScroll(ItemResource itemResource, Storage<ItemVariant> destinationStorage) {
        this.gridOperations.extract(itemResource, GridExtractMode.SINGLE_RESOURCE, (resource, amount, action, source) -> {
            if (!(resource instanceof ItemResource)) {
                return 0L;
            }
            ItemResource itemResource2 = (ItemResource)resource;
            ItemVariant itemVariant = VariantUtil.toItemVariant(itemResource2);
            try (Transaction tx = Transaction.openOuter();){
                long inserted = destinationStorage.insert((Object)itemVariant, amount, (TransactionContext)tx);
                if (action == Action.EXECUTE) {
                    tx.commit();
                }
                long l = inserted;
                return l;
            }
        });
    }
}

