/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.importer;

import com.google.common.collect.Iterators;
import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.ImporterSource;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.fabric.storage.FabricStorageExtractableStorage;
import com.refinedmods.refinedstorage.fabric.storage.FabricStorageInsertableStorage;
import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

class FabricStorageImporterSource<T>
implements ImporterSource {
    private final BlockApiCache<Storage<T>, class_2350> cache;
    private final Function<T, ResourceKey> fromPlatformMapper;
    private final FabricStorageInsertableStorage<T> insertTarget;
    private final FabricStorageExtractableStorage<T> extractTarget;
    private final class_2350 direction;

    FabricStorageImporterSource(BlockApiLookup<Storage<T>, class_2350> lookup, Function<T, ResourceKey> fromPlatformMapper, Function<ResourceKey, @NullableType T> toPlatformMapper, class_3218 serverLevel, class_2338 pos, class_2350 direction) {
        this.cache = BlockApiCache.create(lookup, (class_3218)serverLevel, (class_2338)pos);
        this.fromPlatformMapper = fromPlatformMapper;
        this.insertTarget = new FabricStorageInsertableStorage<T>(lookup, toPlatformMapper, serverLevel, pos, direction);
        this.extractTarget = new FabricStorageExtractableStorage<T>(lookup, toPlatformMapper, serverLevel, pos, direction);
        this.direction = direction;
    }

    public long getAmount(ResourceKey resource) {
        return this.extractTarget.getAmount(resource);
    }

    @Override
    public Iterator<ResourceKey> getResources() {
        Storage storage = (Storage)this.cache.find((Object)this.direction);
        if (storage == null) {
            return Collections.emptyListIterator();
        }
        Iterator iterator = storage.iterator();
        return Iterators.transform((Iterator)Iterators.filter((Iterator)iterator, storageView -> !storageView.isResourceBlank()), storageView -> this.fromPlatformMapper.apply(storageView.getResource()));
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.extractTarget.extract(resource, amount, action, actor);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        return this.insertTarget.insert(resource, amount, action, actor);
    }
}

