/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.importer;

import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.network.impl.node.importer.ImporterTransferStrategyImpl;
import com.refinedmods.refinedstorage.api.network.node.importer.ImporterTransferStrategy;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.common.api.importer.ImporterTransferStrategyFactory;
import com.refinedmods.refinedstorage.common.api.upgrade.UpgradeState;
import com.refinedmods.refinedstorage.common.importer.ImporterTransferQuotaProvider;
import com.refinedmods.refinedstorage.fabric.importer.FabricStorageImporterSource;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class FabricStorageImporterTransferStrategyFactory<P>
implements ImporterTransferStrategyFactory {
    private final BlockApiLookup<Storage<P>, class_2350> lookup;
    private final Function<P, ResourceKey> fromPlatformMapper;
    private final Function<ResourceKey, @NullableType P> toPlatformMapper;
    private final long singleAmount;

    public FabricStorageImporterTransferStrategyFactory(BlockApiLookup<Storage<P>, class_2350> lookup, Function<P, ResourceKey> fromPlatformMapper, Function<ResourceKey, @NullableType P> toPlatformMapper, long singleAmount) {
        this.lookup = lookup;
        this.fromPlatformMapper = fromPlatformMapper;
        this.toPlatformMapper = toPlatformMapper;
        this.singleAmount = singleAmount;
    }

    @Override
    public ImporterTransferStrategy create(class_3218 level, class_2338 pos, class_2350 direction, UpgradeState upgradeState) {
        FabricStorageImporterSource<P> source = new FabricStorageImporterSource<P>(this.lookup, this.fromPlatformMapper, this.toPlatformMapper, level, pos, direction);
        ImporterTransferQuotaProvider transferQuotaProvider = new ImporterTransferQuotaProvider(this.singleAmount, upgradeState, source::getAmount);
        return new ImporterTransferStrategyImpl(source, transferQuotaProvider);
    }
}

