/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.storage;

import com.refinedmods.refinedstorage.api.storage.StorageState;
import com.refinedmods.refinedstorage.common.storage.AbstractDiskContainerBlockEntity;
import com.refinedmods.refinedstorage.common.storage.Disk;
import com.refinedmods.refinedstorage.common.util.ClientPlatformUtil;
import com.refinedmods.refinedstorage.fabric.support.render.QuadTranslator;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public abstract class AbstractDiskContainerBakedModel
extends ForwardingBakedModel {
    private final Map<class_1792, class_1087> diskModels;
    private final class_1087 inactiveLedModel;
    private final QuadTranslator[] diskTranslations;

    protected AbstractDiskContainerBakedModel(Map<class_1792, class_1087> diskModels, class_1087 inactiveLedModel, QuadTranslator[] diskTranslations) {
        this.diskModels = diskModels;
        this.inactiveLedModel = inactiveLedModel;
        this.diskTranslations = diskTranslations;
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        Object renderAttachment = blockView.getBlockEntityRenderData(pos);
        if (renderAttachment instanceof Disk[]) {
            Disk[] disks = (Disk[])renderAttachment;
            this.emitDiskQuads(blockView, state, pos, randomSupplier, context, disks);
        }
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_1937 level = ClientPlatformUtil.getClientLevel();
        class_9279 customData = (class_9279)stack.method_57824(class_9334.field_49611);
        if (customData == null || level == null) {
            return;
        }
        for (int i = 0; i < this.diskTranslations.length; ++i) {
            class_1792 diskItem = AbstractDiskContainerBlockEntity.getDisk(customData.method_57463(), i, (class_7225.class_7874)level.method_30349());
            this.emitDiskQuads(stack, randomSupplier, context, diskItem, i);
        }
    }

    private void emitDiskQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, Disk[] disks) {
        for (int i = 0; i < this.diskTranslations.length; ++i) {
            Disk disk = disks[i];
            this.emitDiskQuads(blockView, state, pos, randomSupplier, context, disk, i);
        }
    }

    private void emitDiskQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, Disk disk, int index) {
        if (disk.state() == StorageState.NONE) {
            return;
        }
        class_1087 model = this.diskModels.get(disk.item());
        if (model == null) {
            return;
        }
        context.pushTransform((RenderContext.QuadTransform)this.diskTranslations[index]);
        model.emitBlockQuads(blockView, state, pos, randomSupplier, context);
        context.popTransform();
    }

    private void emitDiskQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context, @Nullable class_1792 diskItem, int index) {
        if (diskItem == null) {
            return;
        }
        class_1087 diskModel = this.diskModels.get(diskItem);
        if (diskModel == null) {
            return;
        }
        context.pushTransform((RenderContext.QuadTransform)this.diskTranslations[index]);
        diskModel.emitItemQuads(stack, randomSupplier, context);
        this.inactiveLedModel.emitItemQuads(stack, randomSupplier, context);
        context.popTransform();
    }
}

