/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.ExtractableStorage;
import com.refinedmods.refinedstorage.fabric.storage.FabricStorageUtil;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class FabricStorageExtractableStorage<P>
implements ExtractableStorage {
    private final BlockApiCache<Storage<P>, class_2350> cache;
    private final Function<ResourceKey, @NullableType P> toPlatformMapper;
    private final class_2350 direction;

    public FabricStorageExtractableStorage(BlockApiLookup<Storage<P>, class_2350> lookup, Function<ResourceKey, @NullableType P> toPlatformMapper, class_3218 serverLevel, class_2338 pos, class_2350 direction) {
        this.cache = BlockApiCache.create(lookup, (class_3218)serverLevel, (class_2338)pos);
        this.toPlatformMapper = toPlatformMapper;
        this.direction = direction;
    }

    public long getAmount(ResourceKey resource) {
        Storage storage = (Storage)this.cache.find((Object)this.direction);
        if (storage == null) {
            return 0L;
        }
        P platformResource = this.toPlatformMapper.apply(resource);
        if (platformResource == null) {
            return 0L;
        }
        return FabricStorageUtil.getCurrentAmount(storage, platformResource);
    }

    @Override
    public long extract(ResourceKey resource, long amount, Action action, Actor actor) {
        Storage storage = (Storage)this.cache.find((Object)this.direction);
        if (storage == null) {
            return 0L;
        }
        P platformResource = this.toPlatformMapper.apply(resource);
        if (platformResource == null) {
            return 0L;
        }
        return this.extract(resource, amount, action, storage);
    }

    private long extract(ResourceKey resource, long amount, Action action, Storage<P> storage) {
        TransactionContext potentialOpenTransactionFromEarlierInTheStack = Transaction.getCurrentUnsafe();
        try (Transaction tx = Transaction.openNested((TransactionContext)potentialOpenTransactionFromEarlierInTheStack);){
            long extract = storage.extract(this.toPlatformMapper.apply(resource), amount, (TransactionContext)tx);
            if (action == Action.EXECUTE) {
                tx.commit();
            }
            long l = extract;
            return l;
        }
    }
}

