/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.fabric.storage;

import com.refinedmods.refinedstorage.api.core.Action;
import com.refinedmods.refinedstorage.api.core.NullableType;
import com.refinedmods.refinedstorage.api.resource.ResourceKey;
import com.refinedmods.refinedstorage.api.storage.Actor;
import com.refinedmods.refinedstorage.api.storage.InsertableStorage;
import com.refinedmods.refinedstorage.fabric.storage.FabricStorageUtil;
import java.util.function.Function;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiCache;
import net.fabricmc.fabric.api.lookup.v1.block.BlockApiLookup;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3218;

public class FabricStorageInsertableStorage<T>
implements InsertableStorage {
    private final BlockApiCache<Storage<T>, class_2350> cache;
    private final Function<ResourceKey, @NullableType T> toPlatformMapper;
    private final class_2350 direction;

    public FabricStorageInsertableStorage(BlockApiLookup<Storage<T>, class_2350> lookup, Function<ResourceKey, @NullableType T> toPlatformMapper, class_3218 serverLevel, class_2338 pos, class_2350 direction) {
        this.cache = BlockApiCache.create(lookup, (class_3218)serverLevel, (class_2338)pos);
        this.toPlatformMapper = toPlatformMapper;
        this.direction = direction;
    }

    public long getAmount(ResourceKey resource) {
        Storage storage = (Storage)this.cache.find((Object)this.direction);
        if (storage == null) {
            return 0L;
        }
        T platformResource = this.toPlatformMapper.apply(resource);
        if (platformResource == null) {
            return 0L;
        }
        return FabricStorageUtil.getCurrentAmount(storage, platformResource);
    }

    @Override
    public long insert(ResourceKey resource, long amount, Action action, Actor actor) {
        Storage storage = (Storage)this.cache.find((Object)this.direction);
        if (storage == null) {
            return 0L;
        }
        T platformResource = this.toPlatformMapper.apply(resource);
        if (platformResource == null) {
            return 0L;
        }
        return this.doInsert(platformResource, amount, action, storage);
    }

    private long doInsert(T platformResource, long amount, Action action, Storage<T> storage) {
        TransactionContext potentialOpenTransactionFromEarlierInTheStack = Transaction.getCurrentUnsafe();
        try (Transaction tx = Transaction.openNested((TransactionContext)potentialOpenTransactionFromEarlierInTheStack);){
            long inserted = storage.insert(platformResource, amount, (TransactionContext)tx);
            if (action == Action.EXECUTE) {
                tx.commit();
            }
            long l = inserted;
            return l;
        }
    }
}

